/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.StandardContentDialog;
import org.opentcs.guing.exchange.TransportOrderUtil;
import org.opentcs.guing.transport.CreateTransportOrderPanel;
import org.opentcs.guing.transport.OrderTypeSuggestionsPool;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class CreateTransportOrderAction
extends AbstractAction {
    public static final String ID = "actions.createTransportOrder";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.mainMenu");
    private final TransportOrderUtil orderUtil;
    private final Component dialogParent;
    private final Provider<CreateTransportOrderPanel> orderPanelProvider;
    private final OrderTypeSuggestionsPool typeSuggestionsPool;

    @Inject
    public CreateTransportOrderAction(TransportOrderUtil orderUtil, @ApplicationFrame Component dialogParent, Provider<CreateTransportOrderPanel> orderPanelProvider, OrderTypeSuggestionsPool typeSuggestionsPool) {
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        this.orderPanelProvider = Objects.requireNonNull(orderPanelProvider, "orderPanelProvider");
        this.typeSuggestionsPool = Objects.requireNonNull(typeSuggestionsPool, "typeSuggestionsPool");
        this.putValue("Name", BUNDLE.getString("createTransportOrderAction.name"));
        this.putValue("MnemonicKey", 84);
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/toolbar/create-order.22.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.createTransportOrder();
    }

    public void createTransportOrder() {
        CreateTransportOrderPanel contentPanel = (CreateTransportOrderPanel)((Object)this.orderPanelProvider.get());
        StandardContentDialog dialog = new StandardContentDialog(this.dialogParent, (DialogContent)contentPanel);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() != 1) {
            return;
        }
        this.orderUtil.createTransportOrder(contentPanel.getDestinationModels(), contentPanel.getActions(), contentPanel.getSelectedDeadline(), contentPanel.getSelectedVehicle(), contentPanel.getSelectedType());
        this.typeSuggestionsPool.addTypeSuggestion(contentPanel.getSelectedType());
    }
}

