/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.components.dialogs.ClosableDialog;
import org.opentcs.guing.components.dialogs.FindVehiclePanel;
import org.opentcs.guing.components.dialogs.FindVehiclePanelFactory;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.Comparators;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class FindVehicleAction
extends AbstractAction {
    public static final String ID = "actions.findVehicle";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.mainMenu");
    private final ModelManager modelManager;
    private final OpenTCSDrawingEditor drawingEditor;
    private final Component dialogParent;
    private final FindVehiclePanelFactory panelFactory;

    @Inject
    public FindVehicleAction(ModelManager modelManager, OpenTCSDrawingEditor drawingEditor, @ApplicationFrame Component dialogParent, FindVehiclePanelFactory panelFactory) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.drawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        this.panelFactory = Objects.requireNonNull(panelFactory, "panelFactory");
        this.putValue("Name", BUNDLE.getString("findVehicleAction.name"));
        this.putValue("MnemonicKey", 70);
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/toolbar/find-vehicle.22.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.findVehicle();
    }

    private void findVehicle() {
        ArrayList<VehicleModel> vehicles = new ArrayList<VehicleModel>(this.modelManager.getModel().getVehicleModels());
        if (vehicles.isEmpty()) {
            return;
        }
        Collections.sort(vehicles, Comparators.modelComponentsByName());
        FindVehiclePanel content = this.panelFactory.createFindVehiclesPanel(vehicles, this.drawingEditor.getActiveView());
        String title = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.findVehicle").getString("findVehicleAction.dialog_findVehicle.title");
        ClosableDialog dialog = new ClosableDialog(this.dialogParent, true, (JComponent)content, title);
        dialog.setLocationRelativeTo(this.dialogParent);
        dialog.setVisible(true);
    }
}

