/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.actions;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.drivers.vehicle.messages.SetSpeedMultiplier;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PauseAllVehiclesAction
extends AbstractAction {
    public static final String ID = "openTCS.pauseAllVehicles";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.toolbar");
    private static final Logger LOG = LoggerFactory.getLogger(PauseAllVehiclesAction.class);
    private final ModelManager modelManager;
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public PauseAllVehiclesAction(ModelManager modelManager, SharedKernelServicePortalProvider portalProvider) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.putValue("Name", BUNDLE.getString("pauseAllVehiclesAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("pauseAllVehiclesAction.shortDescription"));
        ImageIcon iconSmall = ImageDirectory.getImageIcon((String)"/toolbar/pause-vehicles.16.png");
        ImageIcon iconLarge = ImageDirectory.getImageIcon((String)"/toolbar/pause-vehicles.22.png");
        this.putValue("SmallIcon", iconSmall);
        this.putValue("SwingLargeIconKey", iconLarge);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            this.pauseVehicles(sharedPortal.getPortal());
        }
        catch (ServiceUnavailableException exc) {
            LOG.warn("Could not connect to kernel", (Throwable)exc);
        }
    }

    private void pauseVehicles(KernelServicePortal portal) {
        if (portal == null) {
            return;
        }
        ModelComponent folder = this.modelManager.getModel().getMainFolder(SystemModel.FolderKey.VEHICLES);
        if (this.portalProvider.portalShared()) {
            for (ModelComponent component : folder.getChildComponents()) {
                VehicleModel vModel = (VehicleModel)component;
                LOG.info("Pausing vehicle {}...", (Object)vModel.getVehicle().getName());
                portal.getVehicleService().sendCommAdapterMessage(vModel.getVehicle().getReference(), (Object)new SetSpeedMultiplier(0));
            }
        }
    }
}

