/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class ScrollToVehicleAction
extends AbstractAction {
    public static final String ID = "course.vehicle.scrollTo";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final VehicleModel vehicleModel;
    private final OpenTCSDrawingEditor drawingEditor;
    private final ModelManager modelManager;

    @Inject
    public ScrollToVehicleAction(@Assisted VehicleModel vehicle, OpenTCSDrawingEditor drawingEditor, ModelManager modelManager) {
        this.vehicleModel = Objects.requireNonNull(vehicle, "vehicle");
        this.drawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.putValue("Name", BUNDLE.getString("scrollToVehicleAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Figure figure = this.modelManager.getModel().getFigure((ModelComponent)this.vehicleModel);
        OpenTCSDrawingView drawingView = this.drawingEditor.getActiveView();
        if (drawingView != null && figure != null) {
            drawingView.clearSelection();
            drawingView.addToSelection(figure);
            drawingView.scrollTo(figure);
        }
    }
}

