/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.InputValidationListener;
import org.opentcs.guing.components.dialogs.StandardContentDialog;
import org.opentcs.guing.exchange.TransportOrderUtil;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.transport.PointPanel;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class SendVehicleToPointAction
extends AbstractAction {
    public static final String ID = "course.vehicle.sendToPoint";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final VehicleModel vehicleModel;
    private final JFrame applicationFrame;
    private final ModelManager modelManager;
    private final TransportOrderUtil orderUtil;

    @Inject
    public SendVehicleToPointAction(@Assisted VehicleModel vehicle, @ApplicationFrame JFrame applicationFrame, ModelManager modelManager, TransportOrderUtil orderUtil) {
        this.vehicleModel = Objects.requireNonNull(vehicle, "vehicle");
        this.applicationFrame = Objects.requireNonNull(applicationFrame, "applicationFrame");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.putValue("Name", BUNDLE.getString("sendVehicleToPointAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        List<PointModel> pointModels = this.pointModels();
        if (!pointModels.isEmpty()) {
            PointPanel contentPanel = new PointPanel(pointModels);
            StandardContentDialog fDialog = new StandardContentDialog((Component)this.applicationFrame, (DialogContent)contentPanel);
            contentPanel.addInputValidationListener((InputValidationListener)fDialog);
            fDialog.setTitle(evt.getActionCommand());
            fDialog.setVisible(true);
            if (fDialog.getReturnStatus() == 1) {
                PointModel point = (PointModel)contentPanel.getSelectedItem();
                this.orderUtil.createTransportOrder(point, this.vehicleModel);
            }
        }
    }

    private List<PointModel> pointModels() {
        return this.modelManager.getModel().getPointModels();
    }
}

