/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.menus;

import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.application.action.ActionFactory;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class VehiclePopupMenu
extends JPopupMenu {
    @Inject
    public VehiclePopupMenu(ModelManager modelManager, ActionFactory actionFactory, @Assisted Collection<VehicleModel> vehicles) {
        AbstractAction action;
        Objects.requireNonNull(modelManager, "modelManager");
        Objects.requireNonNull(actionFactory, "actionFactory");
        Objects.requireNonNull(vehicles, "vehicles");
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
        VehicleModel singleVehicle = vehicles.stream().findFirst().get();
        JMenuItem mi = new JMenuItem();
        mi.setEnabled(false);
        if (vehicles.size() == 1) {
            mi.setText(bundle.getString("vehiclePopupMenu.menuItem_singleVehicle.text") + singleVehicle.getName());
        } else {
            mi.setText(bundle.getString("vehiclePopupMenu.menuItem_multipleVehicles.text"));
        }
        this.add(mi);
        this.addSeparator();
        if (vehicles.size() == 1) {
            action = actionFactory.createScrollToVehicleAction(singleVehicle);
            this.add(action);
            action = actionFactory.createFollowVehicleAction(singleVehicle);
            JCheckBoxMenuItem followCheckBox = new JCheckBoxMenuItem();
            followCheckBox.setAction(action);
            followCheckBox.setSelected(singleVehicle.isViewFollows());
            this.add(followCheckBox);
            this.addSeparator();
        }
        if (vehicles.size() == 1) {
            action = actionFactory.createSendVehicleToPointAction(singleVehicle);
            action.setEnabled(singleVehicle.isAvailableForOrder() && !modelManager.getModel().getPointModels().isEmpty());
            this.add(action);
            action = actionFactory.createSendVehicleToLocationAction(singleVehicle);
            action.setEnabled(singleVehicle.isAvailableForOrder() && !modelManager.getModel().getLocationModels().isEmpty());
            this.add(action);
            this.addSeparator();
        }
        JMenu integrateSubMenu = new JMenu(bundle.getString("vehiclePopupMenu.subMenu_integrate.text"));
        action = actionFactory.createIntegrationLevelChangeAction(vehicles, Vehicle.IntegrationLevel.TO_BE_IGNORED);
        action.setEnabled(!this.isAnyProcessingOrder(vehicles));
        JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(action);
        checkBoxMenuItem.setSelected(this.isAnyAtIntegrationLevel(vehicles, Vehicle.IntegrationLevel.TO_BE_IGNORED));
        integrateSubMenu.add(checkBoxMenuItem);
        action = actionFactory.createIntegrationLevelChangeAction(vehicles, Vehicle.IntegrationLevel.TO_BE_NOTICED);
        action.setEnabled(!this.isAnyProcessingOrder(vehicles));
        checkBoxMenuItem = new JCheckBoxMenuItem(action);
        checkBoxMenuItem.setSelected(this.isAnyAtIntegrationLevel(vehicles, Vehicle.IntegrationLevel.TO_BE_NOTICED));
        integrateSubMenu.add(checkBoxMenuItem);
        action = actionFactory.createIntegrationLevelChangeAction(vehicles, Vehicle.IntegrationLevel.TO_BE_RESPECTED);
        checkBoxMenuItem = new JCheckBoxMenuItem(action);
        checkBoxMenuItem.setSelected(this.isAnyAtIntegrationLevel(vehicles, Vehicle.IntegrationLevel.TO_BE_RESPECTED));
        integrateSubMenu.add(checkBoxMenuItem);
        action = actionFactory.createIntegrationLevelChangeAction(vehicles, Vehicle.IntegrationLevel.TO_BE_UTILIZED);
        checkBoxMenuItem = new JCheckBoxMenuItem(action);
        checkBoxMenuItem.setSelected(this.isAnyAtIntegrationLevel(vehicles, Vehicle.IntegrationLevel.TO_BE_UTILIZED));
        integrateSubMenu.add(checkBoxMenuItem);
        this.add(integrateSubMenu);
        this.addSeparator();
        JMenu withdrawSubMenu = new JMenu(bundle.getString("vehiclePopupMenu.subMenu_withdraw.text"));
        action = actionFactory.createWithdrawAction(vehicles, false);
        action.setEnabled(this.isAnyProcessingOrder(vehicles));
        withdrawSubMenu.add(action);
        action = actionFactory.createWithdrawAction(vehicles, true);
        action.setEnabled(this.isAnyProcessingOrder(vehicles));
        withdrawSubMenu.add(action);
        this.add(withdrawSubMenu);
    }

    private boolean isAnyProcessingOrder(Collection<VehicleModel> vehicles) {
        return vehicles.stream().anyMatch(vehicle -> this.isProcessingOrder((VehicleModel)vehicle));
    }

    private boolean isProcessingOrder(VehicleModel vehicle) {
        return vehicle.getPropertyProcState().getValue() == Vehicle.ProcState.PROCESSING_ORDER || vehicle.getPropertyProcState().getValue() == Vehicle.ProcState.AWAITING_ORDER;
    }

    private boolean isAnyAtIntegrationLevel(Collection<VehicleModel> vehicles, Vehicle.IntegrationLevel level) {
        return vehicles.stream().anyMatch(vehicle -> vehicle.getPropertyIntegrationLevel().getComparableValue().equals(level));
    }
}

