/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.menus.menubar;

import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.application.action.ViewActionMap;
import org.opentcs.guing.application.menus.MenuFactory;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.figures.VehicleFigure;
import org.opentcs.guing.util.PlantOverviewOperatingApplicationConfiguration;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class ActionsMenu
extends JMenu {
    private final JMenuItem menuItemCreateTransportOrder;
    private final JMenuItem menuItemCreatePeripheralJob;
    private final JMenuItem menuItemFindVehicle;
    private final JCheckBoxMenuItem cbiIgnorePrecisePosition;
    private final JCheckBoxMenuItem cbiIgnoreOrientationAngle;

    @Inject
    public ActionsMenu(ViewActionMap actionMap, OpenTCSDrawingEditor drawingEditor, MenuFactory menuFactory, PlantOverviewOperatingApplicationConfiguration appConfig) {
        Objects.requireNonNull(actionMap, "actionMap");
        Objects.requireNonNull(drawingEditor, "drawingEditor");
        Objects.requireNonNull(menuFactory, "menuFactory");
        Objects.requireNonNull(appConfig, "appConfig");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.mainMenu");
        this.setText(labels.getString("actionsMenu.text"));
        this.setToolTipText(labels.getString("actionsMenu.tooltipText"));
        this.setMnemonic('A');
        this.menuItemCreateTransportOrder = new JMenuItem(actionMap.get("actions.createTransportOrder"));
        this.add(this.menuItemCreateTransportOrder);
        this.menuItemCreatePeripheralJob = new JMenuItem(actionMap.get("actions.createPeripheralJob"));
        this.add(this.menuItemCreatePeripheralJob);
        this.addSeparator();
        this.menuItemFindVehicle = new JMenuItem(actionMap.get("actions.findVehicle"));
        this.add(this.menuItemFindVehicle);
        this.cbiIgnorePrecisePosition = new JCheckBoxMenuItem(labels.getString("actionsMenu.menuItem_ignorePrecisePosition.text"));
        this.add(this.cbiIgnorePrecisePosition);
        this.cbiIgnorePrecisePosition.setSelected(appConfig.ignoreVehiclePrecisePosition());
        this.cbiIgnorePrecisePosition.addActionListener(e -> {
            for (Figure figure : drawingEditor.getDrawing().getChildren()) {
                if (!(figure instanceof VehicleFigure)) continue;
                ((VehicleFigure)figure).setIgnorePrecisePosition(this.cbiIgnorePrecisePosition.isSelected());
            }
        });
        this.cbiIgnoreOrientationAngle = new JCheckBoxMenuItem(labels.getString("actionsMenu.menuItem_ignorePreciseOrientation.text"));
        this.add(this.cbiIgnoreOrientationAngle);
        this.cbiIgnoreOrientationAngle.setSelected(appConfig.ignoreVehicleOrientationAngle());
        this.cbiIgnoreOrientationAngle.addActionListener(e -> {
            for (Figure figure : drawingEditor.getDrawing().getChildren()) {
                if (!(figure instanceof VehicleFigure)) continue;
                ((VehicleFigure)figure).setIgnoreOrientationAngle(this.cbiIgnoreOrientationAngle.isSelected());
            }
        });
    }
}

