/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.dialogs;

import com.google.common.base.Preconditions;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.properties.type.StringSetProperty;
import org.opentcs.guing.model.AbstractConnectableModelComponent;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.LocationTypeModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class EditDriveOrderPanel
extends DialogContent {
    private final List<LocationModel> fLocations;
    private AbstractConnectableModelComponent fSelectedLocation;
    private String fSelectedAction;
    private JComboBox<String> actionComboBox;
    private JLabel actionLabel;
    private JComboBox<String> locationComboBox;
    private JLabel stationLabel;

    public EditDriveOrderPanel(List<LocationModel> locations) {
        this.initComponents();
        this.fLocations = this.sortLocations(locations);
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.createTransportOrder").getString("editDriverOrderPanel.create.title"));
    }

    public EditDriveOrderPanel(List<LocationModel> locations, AbstractConnectableModelComponent location, String action) {
        Preconditions.checkArgument((location instanceof PointModel || location instanceof LocationModel ? 1 : 0) != 0, (Object)String.format("Selected location has to be of type PointModel or LocationModel and not \"%s\".", location.getClass().getName()));
        this.initComponents();
        this.fLocations = this.sortLocations(locations);
        this.fSelectedLocation = location;
        this.fSelectedAction = action;
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.createTransportOrder").getString("editDriverOrderPanel.edit.title"));
    }

    private List<LocationModel> sortLocations(List<LocationModel> locations) {
        Comparator<LocationModel> c = new Comparator<LocationModel>(){

            @Override
            public int compare(LocationModel o1, LocationModel o2) {
                String s1 = o1.getName().toLowerCase();
                String s2 = o2.getName().toLowerCase();
                return s1.compareTo(s2);
            }
        };
        ArrayList<LocationModel> result = new ArrayList<LocationModel>(locations);
        Collections.sort(result, c);
        return result;
    }

    public void update() {
    }

    public void initFields() {
        for (LocationModel s : this.fLocations) {
            this.locationComboBox.addItem(s.getName());
        }
        if (this.fSelectedLocation != null) {
            this.locationComboBox.setSelectedItem(this.fSelectedLocation.getName());
        } else if (this.locationComboBox.getItemCount() > 0) {
            this.locationComboBox.setSelectedIndex(0);
        }
        if (this.fSelectedAction != null) {
            this.actionComboBox.setSelectedItem(this.fSelectedAction);
        }
    }

    public Optional<LocationModel> getSelectedLocation() {
        int index = this.locationComboBox.getSelectedIndex();
        return index == -1 ? Optional.empty() : Optional.ofNullable(this.fLocations.get(index));
    }

    public Optional<String> getSelectedAction() {
        return Optional.ofNullable((String)this.actionComboBox.getSelectedItem());
    }

    private void initComponents() {
        this.stationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.actionLabel = new JLabel();
        this.actionComboBox = new JComboBox();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 5, 0};
        layout.rowHeights = new int[]{0, 5, 0};
        this.setLayout(layout);
        this.stationLabel.setFont(this.stationLabel.getFont());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/createTransportOrder");
        this.stationLabel.setText(bundle.getString("editDriverOrderPanel.label_location.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add(this.stationLabel, gridBagConstraints);
        this.locationComboBox.setFont(this.locationComboBox.getFont());
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditDriveOrderPanel.this.locationComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.add(this.locationComboBox, gridBagConstraints);
        this.actionLabel.setFont(this.actionLabel.getFont());
        this.actionLabel.setText(bundle.getString("editDriverOrderPanel.label_action.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add(this.actionLabel, gridBagConstraints);
        this.actionComboBox.setFont(this.actionComboBox.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.add(this.actionComboBox, gridBagConstraints);
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.actionComboBox.getModel();
        model.removeAllElements();
        this.getSelectedLocation().ifPresent(location -> {
            LocationTypeModel type = location.getLocationType();
            StringSetProperty p = type.getPropertyAllowedOperations();
            for (String item : new ArrayList(type.getPropertyAllowedOperations().getItems())) {
                model.addElement(item);
            }
            if (model.getSize() > 0) {
                this.actionComboBox.setSelectedIndex(0);
            }
        });
    }
}

