/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.dialogs;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.figures.VehicleFigure;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;

public class FindVehiclePanel
extends JPanel {
    private final List<VehicleModel> fVehicles;
    private final OpenTCSDrawingView fDrawingView;
    private final ModelManager modelManager;
    private JButton buttonFind;
    private JComboBox<String> comboBoxVehicles;
    private JLabel labelVehicles;

    @Inject
    public FindVehiclePanel(@Assisted Collection<VehicleModel> vehicles, @Assisted OpenTCSDrawingView drawingView, ModelManager modelManager) {
        this.fVehicles = new ArrayList<VehicleModel>(Objects.requireNonNull(vehicles, "vehicles"));
        this.fDrawingView = Objects.requireNonNull(drawingView, "drawingView");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.initComponents();
        for (VehicleModel vehicle : vehicles) {
            this.comboBoxVehicles.addItem(vehicle.getName());
        }
    }

    public VehicleModel getSelectedVehicle() {
        int index = this.comboBoxVehicles.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.fVehicles.get(index);
    }

    private void initComponents() {
        this.labelVehicles = new JLabel();
        this.comboBoxVehicles = new JComboBox();
        this.buttonFind = new JButton();
        this.labelVehicles.setFont(this.labelVehicles.getFont());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/findVehicle");
        this.labelVehicles.setText(bundle.getString("findVehiclePanel.label_vehicles.text"));
        this.add(this.labelVehicles);
        this.comboBoxVehicles.setFont(this.comboBoxVehicles.getFont());
        this.add(this.comboBoxVehicles);
        this.buttonFind.setFont(this.buttonFind.getFont());
        this.buttonFind.setText(bundle.getString("findVehiclePanel.button_find.text"));
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindVehiclePanel.this.buttonFindActionPerformed(evt);
            }
        });
        this.add(this.buttonFind);
    }

    private void buttonFindActionPerformed(ActionEvent evt) {
        VehicleModel vehicle = this.getSelectedVehicle();
        if (vehicle == null) {
            return;
        }
        VehicleFigure figure = (VehicleFigure)this.modelManager.getModel().getFigure((ModelComponent)vehicle);
        if (figure != null) {
            this.fDrawingView.scrollTo((Figure)figure);
        }
    }
}

