/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.drawing;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JToggleButton;
import org.jhotdraw.draw.DrawingView;
import org.opentcs.guing.application.StatusPanel;
import org.opentcs.guing.components.drawing.DrawingOptions;
import org.opentcs.guing.components.drawing.DrawingViewPlacardPanel;
import org.opentcs.guing.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.ViewDragScrollListener;
import org.opentcs.guing.exchange.TransportOrderUtil;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;

public class DrawingViewFactory {
    private final Provider<OpenTCSDrawingView> drawingViewProvider;
    private final OpenTCSDrawingEditor drawingEditor;
    private final StatusPanel statusPanel;
    private final ModelManager modelManager;
    private final TransportOrderUtil orderUtil;
    private final DrawingOptions drawingOptions;

    @Inject
    public DrawingViewFactory(Provider<OpenTCSDrawingView> drawingViewProvider, OpenTCSDrawingEditor drawingEditor, StatusPanel statusPanel, ModelManager modelManager, TransportOrderUtil orderUtil, DrawingOptions drawingOptions) {
        this.drawingViewProvider = Objects.requireNonNull(drawingViewProvider, "drawingViewProvider");
        this.drawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.drawingOptions = Objects.requireNonNull(drawingOptions, "drawingOptions");
    }

    public DrawingViewScrollPane createDrawingView(SystemModel systemModel, JToggleButton selectionToolButton, JToggleButton dragToolButton) {
        Objects.requireNonNull(systemModel, "systemModel");
        Objects.requireNonNull(selectionToolButton, "selectionToolButton");
        Objects.requireNonNull(dragToolButton, "dragToolButton");
        OpenTCSDrawingView drawingView = (OpenTCSDrawingView)this.drawingViewProvider.get();
        this.drawingEditor.add((DrawingView)drawingView);
        this.drawingEditor.setActiveView((DrawingView)drawingView);
        for (VehicleModel vehicle : systemModel.getVehicleModels()) {
            drawingView.displayDriveOrders(vehicle, vehicle.getDisplayDriveOrders());
        }
        DrawingViewPlacardPanel placardPanel = new DrawingViewPlacardPanel(drawingView, this.drawingOptions);
        DrawingViewScrollPane scrollPane = new DrawingViewScrollPane(drawingView, placardPanel);
        scrollPane.originChanged(systemModel.getDrawingMethod().getOrigin());
        ViewDragScrollListener dragScrollListener = new ViewDragScrollListener(scrollPane, placardPanel.getZoomComboBox(), selectionToolButton, dragToolButton, this.statusPanel, this.modelManager, this.orderUtil);
        drawingView.addMouseListener((MouseListener)dragScrollListener);
        drawingView.addMouseMotionListener((MouseMotionListener)dragScrollListener);
        drawingView.getComponent().addMouseWheelListener(dragScrollListener);
        return scrollPane;
    }
}

