/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.drawing;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.figures.NamedVehicleFigure;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.components.properties.event.NullAttributesChangeListener;
import org.opentcs.guing.event.SystemModelTransitionEvent;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.CourseObjectFactory;
import org.opentcs.guing.util.VehicleCourseObjectFactory;

public class OpenTCSDrawingEditorOperating
extends OpenTCSDrawingEditor {
    private final ModelManager modelManager;
    private final VehicleCourseObjectFactory courseObjectFactory;

    @Inject
    public OpenTCSDrawingEditorOperating(VehicleCourseObjectFactory courseObjectFactory, ModelManager modelManager) {
        super((CourseObjectFactory)courseObjectFactory);
        this.courseObjectFactory = Objects.requireNonNull(courseObjectFactory, "courseObjectFactory");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            this.handleSystemModelTransition((SystemModelTransitionEvent)event);
        }
    }

    private void handleSystemModelTransition(SystemModelTransitionEvent evt) {
        switch (evt.getStage()) {
            case UNLOADING: {
                break;
            }
            case LOADED: {
                this.setVehicles(this.modelManager.getModel().getVehicleModels());
                break;
            }
        }
    }

    public void setVehicles(List<VehicleModel> vehicleModels) {
        for (VehicleModel vehicleComp : vehicleModels) {
            this.addVehicle(vehicleComp);
        }
    }

    public void addVehicle(VehicleModel vehicleModel) {
        NamedVehicleFigure vehicleFigure = this.courseObjectFactory.createNamedVehicleFigure(vehicleModel);
        SwingUtilities.invokeLater(() -> this.getDrawing().add((Figure)vehicleFigure));
        vehicleModel.addAttributesChangeListener((AttributesChangeListener)vehicleFigure);
        this.modelManager.getModel().registerFigure((ModelComponent)vehicleModel, (Figure)vehicleFigure);
        vehicleModel.setDisplayDriveOrders(true);
        for (OpenTCSDrawingView view : this.getAllViews()) {
            view.displayDriveOrders(vehicleModel, true);
        }
        vehicleFigure.propertiesChanged(new AttributesChangeEvent((AttributesChangeListener)new NullAttributesChangeListener(), (ModelComponent)vehicleModel));
    }
}

