/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.drawing;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.application.StatusPanel;
import org.opentcs.guing.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.ZoomItem;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledLocationFigure;
import org.opentcs.guing.components.drawing.figures.LabeledPointFigure;
import org.opentcs.guing.components.drawing.figures.PathConnection;
import org.opentcs.guing.components.drawing.figures.VehicleFigure;
import org.opentcs.guing.components.drawing.figures.liner.TripleBezierLiner;
import org.opentcs.guing.components.drawing.figures.liner.TupelBezierLiner;
import org.opentcs.guing.exchange.TransportOrderUtil;
import org.opentcs.guing.model.elements.LayoutModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.Cursors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDragScrollListener
extends MouseAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ViewDragScrollListener.class);
    private final DrawingViewScrollPane scrollPane;
    private final JComboBox<ZoomItem> zoomComboBox;
    private final JToggleButton selectionTool;
    private final JToggleButton dragTool;
    private final StatusPanel statusPanel;
    private final ModelManager modelManager;
    private final TransportOrderUtil orderUtil;
    private final Cursor defaultCursor;
    private final Point startPoint = new Point();
    private final Point2D.Double fMouseStartPoint = new Point2D.Double();
    private final Point2D.Double fMouseCurrentPoint = new Point2D.Double();
    private final Point2D.Double fMouseEndPoint = new Point2D.Double();
    private Figure pressedFigure;

    public ViewDragScrollListener(DrawingViewScrollPane scrollPane, JComboBox<ZoomItem> zoomComboBox, JToggleButton selectionTool, JToggleButton dragTool, StatusPanel statusPanel, ModelManager modelManager, TransportOrderUtil orderUtil) {
        this.scrollPane = Objects.requireNonNull(scrollPane, "scrollPane");
        this.zoomComboBox = Objects.requireNonNull(zoomComboBox, "zoomComboBox");
        this.selectionTool = Objects.requireNonNull(selectionTool, "selectionTool");
        this.dragTool = Objects.requireNonNull(dragTool, "dragTool");
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.defaultCursor = scrollPane.getDrawingView().getComponent().getCursor();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        OpenTCSDrawingView drawingView = this.scrollPane.getDrawingView();
        if (this.vehicleDragged()) {
            drawingView.setCursor(Cursors.getDragVehicleCursor());
        }
        if (!(drawingView.getComponent().getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)drawingView.getComponent().getParent();
        Point cp = SwingUtilities.convertPoint(drawingView.getComponent(), evt.getPoint(), viewport);
        if (this.dragTool.isSelected()) {
            int dx = this.startPoint.x - cp.x;
            int dy = this.startPoint.y - cp.y;
            Point vp = viewport.getViewPosition();
            vp.translate(dx, dy);
            drawingView.getComponent().scrollRectToVisible(new Rectangle(vp, viewport.getSize()));
        } else {
            viewport.revalidate();
            if (this.isMovableFigure(this.pressedFigure)) {
                if (!this.isFigureCompletelyInView(this.pressedFigure, viewport, (DrawingView)drawingView)) {
                    drawingView.getComponent().scrollRectToVisible(new Rectangle(evt.getX(), evt.getY(), 1, 1));
                }
                this.fMouseCurrentPoint.setLocation(drawingView.viewToDrawing(evt.getPoint()));
                this.showPositionStatus(false);
                this.startPoint.setLocation(cp);
            }
        }
        SwingUtilities.invokeLater(() -> this.lambda$mouseDragged$0((DrawingView)drawingView));
    }

    private boolean isMovableFigure(Figure figure) {
        return figure instanceof LabeledPointFigure || figure instanceof LabeledLocationFigure || figure instanceof PathConnection && ((PathConnection)figure).getLiner() instanceof TupelBezierLiner || figure instanceof PathConnection && ((PathConnection)figure).getLiner() instanceof TripleBezierLiner;
    }

    private boolean isFigureCompletelyInView(Figure figure, JViewport viewport, DrawingView drawingView) {
        Rectangle viewPortBounds = viewport.getViewRect();
        Rectangle figureBounds = drawingView.drawingToView(figure.getDrawingArea());
        return figureBounds.getMinX() > viewPortBounds.getMinX() && figureBounds.getMinY() > viewPortBounds.getMinY() && figureBounds.getMaxX() < viewPortBounds.getMaxX() && figureBounds.getMaxY() < viewPortBounds.getMaxY();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        Container c;
        OpenTCSDrawingView drawingView = this.scrollPane.getDrawingView();
        if (this.dragIsSelected()) {
            drawingView.setCursor(Cursor.getPredefinedCursor(13));
        }
        if ((c = drawingView.getComponent().getParent()) instanceof JViewport) {
            JViewport viewPort = (JViewport)c;
            Point cp = SwingUtilities.convertPoint(drawingView.getComponent(), evt.getPoint(), viewPort);
            this.startPoint.setLocation(cp);
        }
        this.pressedFigure = drawingView.findFigure(evt.getPoint());
        this.fMouseCurrentPoint.setLocation(drawingView.viewToDrawing(evt.getPoint()));
        this.fMouseStartPoint.setLocation(drawingView.viewToDrawing(evt.getPoint()));
        this.showPositionStatus(false);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.dragIsSelected()) {
            return;
        }
        OpenTCSDrawingView drawingView = this.scrollPane.getDrawingView();
        Figure fig = drawingView.findFigure(evt.getPoint());
        if (fig instanceof LabeledPointFigure) {
            this.createPossibleTransportOrder((LabeledPointFigure)fig, drawingView.getSelectedFigures());
        }
        this.pressedFigure = null;
        this.fMouseEndPoint.setLocation(drawingView.viewToDrawing(evt.getPoint()));
        if (evt.getButton() != 2) {
            this.showPositionStatus(true);
        } else {
            this.showPositionStatus(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.dragIsSelected();
        this.clearPositionStatus();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.dragIsSelected();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        OpenTCSDrawingView drawingView = this.scrollPane.getDrawingView();
        this.fMouseCurrentPoint.setLocation(drawingView.viewToDrawing(evt.getPoint()));
        this.showPositionStatus(false);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getButton() == 2) {
            if (this.dragTool.isSelected()) {
                this.selectionTool.setSelected(true);
            } else if (this.selectionTool.isSelected()) {
                this.dragTool.setSelected(true);
            }
            this.dragIsSelected();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            int zoomLevel = this.zoomComboBox.getSelectedIndex();
            int notches = e.getWheelRotation();
            if (zoomLevel != -1) {
                if (notches < 0) {
                    if (zoomLevel > 0) {
                        this.zoomComboBox.setSelectedIndex(--zoomLevel);
                    }
                } else if (zoomLevel < this.zoomComboBox.getItemCount() - 1) {
                    this.zoomComboBox.setSelectedIndex(++zoomLevel);
                }
            }
        }
    }

    private boolean dragIsSelected() {
        OpenTCSDrawingView drawingView = this.scrollPane.getDrawingView();
        if (!this.selectionTool.isSelected() && this.dragTool.isSelected()) {
            drawingView.setCursor(Cursor.getPredefinedCursor(12));
            return true;
        }
        if (this.selectionTool.isSelected() && !this.dragTool.isSelected()) {
            drawingView.setCursor(this.defaultCursor);
            return false;
        }
        return false;
    }

    private void clearPositionStatus() {
        this.statusPanel.setPositionText("");
    }

    private void showPositionStatus(boolean showCoveredArea) {
        double x = this.fMouseCurrentPoint.x;
        double y = -this.fMouseCurrentPoint.y;
        if (showCoveredArea) {
            double w = Math.abs(this.fMouseEndPoint.x - this.fMouseStartPoint.x);
            double h = Math.abs(this.fMouseEndPoint.y - this.fMouseStartPoint.y);
            this.statusPanel.setPositionText(String.format("X %.0f Y %.0f W %.0f H %.0f", x, y, w, h));
        } else {
            LayoutModel layout = this.modelManager.getModel().getLayoutModel();
            double scaleX = (Double)layout.getPropertyScaleX().getValue();
            double scaleY = (Double)layout.getPropertyScaleY().getValue();
            double xmm = x * scaleX;
            double ymm = y * scaleY;
            this.statusPanel.setPositionText(String.format("X %.0f (%.0fmm) Y %.0f (%.0fmm)", x, xmm, y, ymm));
        }
    }

    private void createPossibleTransportOrder(LabeledPointFigure figure, Set<Figure> selectedFigures) {
        if (selectedFigures.size() != 1) {
            LOG.debug("More than one figure selected, skipping.");
            return;
        }
        Figure nextFigure = selectedFigures.iterator().next();
        if (!(nextFigure instanceof VehicleFigure)) {
            LOG.debug("Selected figure is not a VehicleFigure, skipping.");
            return;
        }
        PointModel model = figure.getPresentationFigure().getModel();
        VehicleModel vehicleModel = (VehicleModel)nextFigure.get(FigureConstants.MODEL);
        if (vehicleModel == null) {
            LOG.warn("Selected VehicleFigure does not have a model, skipping.");
            return;
        }
        if ((Vehicle.ProcState)vehicleModel.getPropertyProcState().getValue() != Vehicle.ProcState.IDLE) {
            LOG.debug("Selected vehicle already has an order, skipping.");
            return;
        }
        this.orderUtil.createTransportOrder(model, vehicleModel);
    }

    private boolean vehicleDragged() {
        Set selectedFigures = this.scrollPane.getDrawingView().getSelectedFigures();
        if (selectedFigures.size() != 1) {
            return false;
        }
        return selectedFigures.iterator().next() instanceof VehicleFigure;
    }

    private /* synthetic */ void lambda$mouseDragged$0(DrawingView drawingView) {
        Rectangle2D.Double drawingArea = drawingView.getDrawing().getDrawingArea();
        this.scrollPane.getHorizontalRuler().setPreferredWidth((int)drawingArea.width);
        this.scrollPane.getVerticalRuler().setPreferredHeight((int)drawingArea.height);
    }
}

