/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.drawing.figures;

import com.google.inject.assistedinject.Assisted;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.geom.BezierPath;
import org.opentcs.components.plantoverview.VehicleTheme;
import org.opentcs.data.model.Triple;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.application.menus.MenuFactory;
import org.opentcs.guing.application.menus.VehiclePopupMenu;
import org.opentcs.guing.components.drawing.ZoomPoint;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledPointFigure;
import org.opentcs.guing.components.drawing.figures.PathConnection;
import org.opentcs.guing.components.drawing.figures.PointFigure;
import org.opentcs.guing.components.drawing.figures.TCSFigure;
import org.opentcs.guing.components.drawing.figures.ToolTipTextGenerator;
import org.opentcs.guing.components.drawing.figures.decoration.VehicleOutlineHandle;
import org.opentcs.guing.components.drawing.figures.liner.TripleBezierLiner;
import org.opentcs.guing.components.drawing.figures.liner.TupelBezierLiner;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.components.properties.type.AngleProperty;
import org.opentcs.guing.model.ConnectableModelComponent;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.SimpleFolder;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.AbstractConnection;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.PlantOverviewOperatingApplicationConfiguration;

public class VehicleFigure
extends TCSFigure
implements AttributesChangeListener,
ImageObserver {
    public static final String POSITION_CHANGED = "position_changed";
    private static final double LENGTH = 30.0;
    private static final double WIDTH = 20.0;
    private final VehicleTheme vehicleTheme;
    private final MenuFactory menuFactory;
    private final ToolTipTextGenerator textGenerator;
    private final ModelManager modelManager;
    private final ApplicationState applicationState;
    private double fAngle;
    protected transient Image fImage;
    private boolean ignorePrecisePosition;
    private boolean ignoreOrientationAngle;
    private boolean figureDetailsChanged = false;

    @Inject
    public VehicleFigure(VehicleTheme vehicleTheme, MenuFactory menuFactory, PlantOverviewOperatingApplicationConfiguration appConfig, @Assisted VehicleModel model, ToolTipTextGenerator textGenerator, ModelManager modelManager, ApplicationState applicationState) {
        super((ModelComponent)model);
        this.vehicleTheme = Objects.requireNonNull(vehicleTheme, "vehicleTheme");
        this.menuFactory = Objects.requireNonNull(menuFactory, "menuFactory");
        this.textGenerator = Objects.requireNonNull(textGenerator, "textGenerator");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.applicationState = Objects.requireNonNull(applicationState, "applicationState");
        this.fDisplayBox = new Rectangle(30, 20);
        this.fZoomPoint = new ZoomPoint(15.0, 10.0);
        this.setIgnorePrecisePosition(appConfig.ignoreVehiclePrecisePosition());
        this.setIgnoreOrientationAngle(appConfig.ignoreVehicleOrientationAngle());
        this.fImage = vehicleTheme.statelessImage(model.getVehicle());
    }

    public VehicleModel getModel() {
        return (VehicleModel)this.get(FigureConstants.MODEL);
    }

    public void setAngle(double angle) {
        this.fAngle = angle;
    }

    public double getAngle() {
        return this.fAngle;
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double r2d = new Rectangle2D.Double();
        r2d.setRect(this.fDisplayBox.getBounds2D());
        return r2d;
    }

    public Object getTransformRestoreData() {
        return this.fDisplayBox.clone();
    }

    public void restoreTransformTo(Object restoreData) {
        Rectangle r = (Rectangle)restoreData;
        this.fDisplayBox.x = r.x;
        this.fDisplayBox.y = r.y;
        this.fDisplayBox.width = r.width;
        this.fDisplayBox.height = r.height;
        this.fZoomPoint.setX(r.getCenterX());
        this.fZoomPoint.setY(r.getCenterY());
    }

    public void transform(AffineTransform tx) {
        Point2D center = this.fZoomPoint.getPixelLocationExactly();
        this.setBounds((Point2D.Double)tx.transform(center, center), null);
    }

    public String getToolTipText(Point2D.Double p) {
        return this.textGenerator.getToolTipText(this.getModel());
    }

    public final void setIgnoreOrientationAngle(boolean doIgnore) {
        this.ignoreOrientationAngle = doIgnore;
        PointModel point = this.getModel().getPoint();
        if (point == null) {
            this.setVisible(!this.ignorePrecisePosition);
        } else {
            Figure pointFigure = this.modelManager.getModel().getFigure((ModelComponent)point);
            Rectangle2D.Double r = pointFigure.getBounds();
            Point2D.Double pCenter = new Point2D.Double(r.getCenterX(), r.getCenterY());
            this.setBounds(pCenter, null);
            this.fireFigureChanged();
        }
    }

    public final void setIgnorePrecisePosition(boolean doIgnore) {
        this.ignorePrecisePosition = doIgnore;
        PointModel point = this.getModel().getPoint();
        if (point == null) {
            this.setVisible(!this.ignorePrecisePosition);
        } else {
            Figure pointFigure = this.modelManager.getModel().getFigure((ModelComponent)point);
            Rectangle2D.Double r = pointFigure.getBounds();
            Point2D.Double pCenter = new Point2D.Double(r.getCenterX(), r.getCenterY());
            this.setBounds(pCenter, null);
            this.fireFigureChanged();
        }
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        VehicleModel model = this.getModel();
        Rectangle2D.Double oldBounds = this.getBounds();
        this.setVisible(false);
        Triple precisePosition = model.getPrecisePosition();
        if (!this.ignorePrecisePosition && precisePosition != null) {
            this.setVisible(true);
            SimpleFolder folder = (SimpleFolder)model.getParent();
            SystemModel systemModel = (SystemModel)folder.getParent();
            double scaleX = systemModel.getDrawingMethod().getOrigin().getScaleX();
            double scaleY = systemModel.getDrawingMethod().getOrigin().getScaleY();
            if (scaleX != 0.0 && scaleY != 0.0) {
                anchor.x = (double)precisePosition.getX() / scaleX;
                anchor.y = (double)(-precisePosition.getY()) / scaleY;
            }
        }
        this.fZoomPoint.setX(anchor.x);
        this.fZoomPoint.setY(anchor.y);
        this.fDisplayBox.x = (int)(anchor.x - 15.0);
        this.fDisplayBox.y = (int)(anchor.y - 10.0);
        this.firePropertyChange(POSITION_CHANGED, oldBounds, this.getBounds());
        this.updateVehicleOrientation();
    }

    private void updateVehicleOrientation() {
        VehicleModel model = this.getModel();
        double angle = model.getOrientationAngle();
        PointModel currentPoint = model.getPoint();
        if (currentPoint != null) {
            this.setVisible(true);
        }
        if (!Double.isNaN(angle) && !this.ignoreOrientationAngle) {
            this.fAngle = angle;
        } else if (currentPoint != null) {
            AngleProperty ap = currentPoint.getPropertyVehicleOrientationAngle();
            angle = (Double)ap.getValue();
            if (!Double.isNaN(angle)) {
                this.fAngle = angle;
            } else {
                this.alignVehicleToNextPoint();
            }
        }
    }

    private void alignVehicleToNextPoint() {
        VehicleModel model = this.getModel();
        PointModel nextPoint = model.getNextPoint();
        PointModel currentPoint = model.getPoint();
        Object connection = model.getDriveOrderState() == TransportOrder.State.BEING_PROCESSED ? model.getCurrentDriveOrderPath() : (nextPoint != null ? currentPoint.getConnectionTo((ConnectableModelComponent)nextPoint) : (AbstractConnection)currentPoint.getConnections().stream().filter(con -> con instanceof PathModel).filter(con -> Objects.equals(con.getStartComponent(), currentPoint)).findFirst().orElse(null));
        if (connection != null) {
            this.fAngle = this.calculateAngle((AbstractConnection)connection);
        }
    }

    private double calculateAngle(AbstractConnection connection) {
        PointModel currentPoint = (PointModel)connection.getStartComponent();
        PointModel nextPoint = (PointModel)connection.getEndComponent();
        PathConnection pathFigure = (PathConnection)this.modelManager.getModel().getFigure((ModelComponent)connection);
        LabeledPointFigure clpf = (LabeledPointFigure)this.modelManager.getModel().getFigure((ModelComponent)currentPoint);
        PointFigure cpf = clpf.getPresentationFigure();
        if (pathFigure.getLiner() instanceof TupelBezierLiner || pathFigure.getLiner() instanceof TripleBezierLiner) {
            BezierPath bezierPath = pathFigure.getBezierPath();
            Point2D.Double cp = bezierPath.get(0, 2);
            double dx = cp.getX() - cpf.getZoomPoint().getX();
            double dy = cp.getY() - cpf.getZoomPoint().getY();
            return Math.toDegrees(Math.atan2(-dy, dx));
        }
        LabeledPointFigure nlpf = (LabeledPointFigure)this.modelManager.getModel().getFigure((ModelComponent)nextPoint);
        PointFigure npf = nlpf.getPresentationFigure();
        double dx = npf.getZoomPoint().getX() - cpf.getZoomPoint().getX();
        double dy = npf.getZoomPoint().getY() - cpf.getZoomPoint().getY();
        return Math.toDegrees(Math.atan2(-dy, dx));
    }

    public void forcedDraw(Graphics2D g2d) {
        this.drawFill(g2d);
    }

    protected void drawFigure(Graphics2D g2d) {
        VehicleModel model = this.getModel();
        PointModel currentPoint = model.getPoint();
        Triple precisePosition = model.getPrecisePosition();
        if (currentPoint != null || precisePosition != null) {
            this.drawFill(g2d);
        }
    }

    protected void drawFill(Graphics2D g2d) {
        if (g2d == null) {
            return;
        }
        Rectangle r = this.displayBox();
        if (this.fImage != null) {
            int dx = (r.width - this.fImage.getWidth(this)) / 2;
            int dy = (r.height - this.fImage.getHeight(this)) / 2;
            int x = r.x + dx;
            int y = r.y + dy;
            AffineTransform oldAF = g2d.getTransform();
            g2d.translate(r.getCenterX(), r.getCenterY());
            g2d.rotate(-Math.toRadians(this.fAngle));
            g2d.translate(-r.getCenterX(), -r.getCenterY());
            g2d.drawImage(this.fImage, x, y, null);
            g2d.setTransform(oldAF);
        }
    }

    protected void drawStroke(Graphics2D g2d) {
    }

    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case -1: {
                handles.add((Handle)new VehicleOutlineHandle((Figure)this));
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
        return handles;
    }

    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView drawingView) {
        VehicleModel model = this.getModel();
        VehiclePopupMenu menu = this.menuFactory.createVehiclePopupMenu(Arrays.asList(model));
        menu.show(drawingView.getComponent(), evt.getX(), evt.getY());
        return false;
    }

    public void propertiesChanged(AttributesChangeEvent e) {
        if (e.getInitiator().equals(this) || e.getModel() == null) {
            return;
        }
        this.updateFigureDetails((VehicleModel)e.getModel());
        if (this.isFigureDetailsChanged()) {
            SwingUtilities.invokeLater(() -> {
                if (this.isVisible()) {
                    this.fireFigureChanged();
                }
            });
            this.setFigureDetailsChanged(false);
        }
    }

    protected void updateFigureDetails(VehicleModel model) {
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x30) != 0) {
            this.invalidate();
        }
        return (infoflags & 0xA0) == 0;
    }

    protected VehicleTheme getVehicleTheme() {
        return this.vehicleTheme;
    }

    public boolean isFigureDetailsChanged() {
        return this.figureDetailsChanged;
    }

    public void setFigureDetailsChanged(boolean figureDetailsChanged) {
        this.figureDetailsChanged = figureDetailsChanged;
    }

    public boolean isIgnorePrecisePosition() {
        return this.ignorePrecisePosition;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }
}

