/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.layer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.opentcs.guing.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.components.layer.LayerGroupEditor;
import org.opentcs.guing.components.layer.LayerGroupManager;
import org.opentcs.guing.components.layer.LayerGroupsTableModel;
import org.opentcs.guing.persistence.ModelManager;

public class LayerGroupsPanel
extends JPanel {
    private final ModelManager modelManager;
    private final LayerGroupManager layerGroupManager;
    private final LayerGroupEditor layerGroupEditor;
    private JTable table;
    private LayerGroupsTableModel tableModel;

    @Inject
    public LayerGroupsPanel(ModelManager modelManager, LayerGroupManager layerGroupManager, LayerGroupEditor layerGroupEditor) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.layerGroupManager = Objects.requireNonNull(layerGroupManager, "layerGroupManager");
        this.layerGroupEditor = Objects.requireNonNull(layerGroupEditor, "layerGroupEditor");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new LayerGroupsTableModel(this.modelManager, this.layerGroupEditor);
        this.layerGroupManager.addLayerGroupChangeListener((LayerGroupChangeListener)this.tableModel);
        this.table = new JTable((TableModel)((Object)this.tableModel));
        this.initTable();
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initTable() {
        this.table.setSelectionMode(0);
        TableRowSorter<LayerGroupsTableModel> sorter = new TableRowSorter<LayerGroupsTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(0)));
    }
}

