/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.layer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.guing.components.layer.LayerChangeListener;
import org.opentcs.guing.components.layer.LayerEditor;
import org.opentcs.guing.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.components.layer.LayerWrapper;
import org.opentcs.guing.persistence.ModelManager;

class LayersTableModel
extends AbstractTableModel
implements LayerChangeListener,
LayerGroupChangeListener {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.panels.layers");
    public static final int COLUMN_ORDINAL = 0;
    public static final int COLUMN_VISIBLE = 1;
    public static final int COLUMN_NAME = 2;
    public static final int COLUMN_GROUP = 3;
    public static final int COLUMN_GROUP_VISIBLE = 4;
    private static final String[] COLUMN_NAMES = new String[]{BUNDLE.getString("layersTableModel.column_ordinal.headerText"), BUNDLE.getString("layersTableModel.column_visible.headerText"), BUNDLE.getString("layersTableModel.column_name.headerText"), BUNDLE.getString("layersTableModel.column_group.headerText"), BUNDLE.getString("layersTableModel.column_groupVisible.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Integer.class, Boolean.class, String.class, LayerGroup.class, Boolean.class};
    private final ModelManager modelManager;
    private final LayerEditor layerEditor;

    public LayersTableModel(ModelManager modelManager, LayerEditor layerEditor) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
    }

    @Override
    public int getRowCount() {
        return this.getLayers().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        Layer entry = this.getLayers().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getOrdinal();
            }
            case 1: {
                return entry.isVisible();
            }
            case 2: {
                return entry.getName();
            }
            case 3: {
                return this.getLayerGroups().get(entry.getGroupId());
            }
            case 4: {
                return this.getLayerGroups().get(entry.getGroupId()).isVisible();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return;
        }
        if (aValue == null) {
            return;
        }
        Layer entry = this.getLayers().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.layerEditor.setLayerVisible(entry.getId(), ((Boolean)aValue).booleanValue());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index: " + columnIndex);
            }
        }
    }

    public void layersInitialized() {
        this.executeOnEventDispatcherThread(() -> this.fireTableDataChanged());
    }

    public void layersChanged() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsUpdated(0, this.getRowCount() - 1));
    }

    public void layerAdded() {
    }

    public void layerRemoved() {
    }

    public void groupsInitialized() {
    }

    public void groupsChanged() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsUpdated(0, this.getRowCount() - 1));
    }

    public void groupAdded() {
    }

    public void groupRemoved() {
    }

    private List<Layer> getLayers() {
        return this.getLayerWrappers().values().stream().map(wrapper -> wrapper.getLayer()).collect(Collectors.toList());
    }

    private Map<Integer, LayerWrapper> getLayerWrappers() {
        return this.modelManager.getModel().getLayoutModel().getPropertyLayerWrappers().getValue();
    }

    private Map<Integer, LayerGroup> getLayerGroups() {
        return this.modelManager.getModel().getLayoutModel().getPropertyLayerGroups().getValue();
    }

    private void executeOnEventDispatcherThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

