/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.event;

import java.util.EventObject;
import java.util.Objects;
import org.opentcs.access.Kernel;

public class KernelStateChangeEvent
extends EventObject {
    private final State newState;

    public KernelStateChangeEvent(Object source, State newState) {
        super(source);
        this.newState = Objects.requireNonNull(newState, "newState");
    }

    public State getNewState() {
        return this.newState;
    }

    @Override
    public String toString() {
        return "KernelStateChangeEvent{newState=" + (Object)((Object)this.newState) + ", source=" + this.getSource() + '}';
    }

    public static State convertKernelState(Kernel.State kernelState) {
        switch (kernelState) {
            case MODELLING: {
                return State.MODELLING;
            }
            case OPERATING: {
                return State.OPERATING;
            }
            case SHUTDOWN: {
                return State.SHUTDOWN;
            }
        }
        throw new IllegalArgumentException("Unhandled state: " + kernelState);
    }

    public static enum State {
        MODELLING,
        OPERATING,
        SHUTDOWN,
        LOGGED_IN,
        DISCONNECTED;

    }
}

