/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.event.SystemModelTransitionEvent;
import org.opentcs.guing.exchange.adapter.LocationLockAdapter;
import org.opentcs.guing.exchange.adapter.PathLockAdapter;
import org.opentcs.guing.exchange.adapter.VehicleAllowedOrderTypesAdapter;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeAdapterRegistry
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeAdapterRegistry.class);
    private final SharedKernelServicePortalProvider portalProvider;
    private final ApplicationState applicationState;
    private final ModelManager modelManager;
    private final EventSource eventSource;
    private boolean initialized;

    @Inject
    public AttributeAdapterRegistry(SharedKernelServicePortalProvider portalProvider, ApplicationState applicationState, ModelManager modelManager, @ApplicationEventBus EventSource eventSource) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.applicationState = Objects.requireNonNull(applicationState, "applicationState");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventSource.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventSource.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            SystemModelTransitionEvent evt = (SystemModelTransitionEvent)event;
            switch (evt.getStage()) {
                case LOADED: {
                    this.registerAdapters();
                    break;
                }
            }
        }
    }

    private void registerAdapters() {
        for (VehicleModel model : this.modelManager.getModel().getVehicleModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new VehicleAllowedOrderTypesAdapter(this.portalProvider, this.applicationState, model));
        }
        for (VehicleModel model : this.modelManager.getModel().getPathModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new PathLockAdapter(this.portalProvider, this.applicationState, (PathModel)model));
        }
        for (VehicleModel model : this.modelManager.getModel().getLocationModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new LocationLockAdapter(this.portalProvider, this.applicationState, (LocationModel)model));
        }
    }
}

