/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelStateTransitionEvent;
import org.opentcs.access.NotificationPublicationEvent;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.application.OperationMode;
import org.opentcs.guing.event.KernelStateChangeEvent;
import org.opentcs.guing.event.OperationModeChangeEvent;
import org.opentcs.guing.exchange.adapter.ProcessAdapter;
import org.opentcs.guing.exchange.adapter.ProcessAdapterUtil;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.MessageDisplay;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCSEventDispatcher
implements Lifecycle,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCSEventDispatcher.class);
    private final MessageDisplay messageDisplay;
    private final EventBus eventBus;
    private final ProcessAdapterUtil processAdapterUtil;
    private final ModelManager modelManager;
    private final SharedKernelServicePortalProvider portalProvider;
    private SharedKernelServicePortal sharedPortal;
    private boolean initialized;

    @Inject
    public OpenTCSEventDispatcher(SharedKernelServicePortalProvider portalProvider, MessageDisplay messageDisplay, @ApplicationEventBus EventBus eventBus, ProcessAdapterUtil processAdapterUtil, ModelManager modelManager) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.messageDisplay = Objects.requireNonNull(messageDisplay, "messageDisplay");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.processAdapterUtil = Objects.requireNonNull(processAdapterUtil, "processAdapterUtil");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void register() {
        if (this.sharedPortal != null) {
            return;
        }
        LOG.debug("EventDispatcher {} registering with portal...", (Object)this);
        if (!this.portalProvider.portalShared()) {
            LOG.warn("No shared portal to register with, aborting.");
            return;
        }
        this.sharedPortal = this.portalProvider.register();
    }

    private void release() {
        if (this.sharedPortal == null) {
            return;
        }
        LOG.debug("EventDispatcher {} unregistering with portal...", (Object)this);
        if (!this.portalProvider.portalShared() || this.sharedPortal == null) {
            LOG.warn("No shared portal to unregister with, aborting.");
            return;
        }
        this.sharedPortal.close();
        this.sharedPortal = null;
    }

    public void onEvent(Object event) {
        if (event instanceof TCSObjectEvent) {
            this.processObjectEvent((TCSObjectEvent)event);
        } else if (event instanceof KernelStateTransitionEvent) {
            KernelStateTransitionEvent kse = (KernelStateTransitionEvent)event;
            if (kse.isTransitionFinished() || kse.getEnteredState() == Kernel.State.SHUTDOWN) {
                this.eventBus.onEvent((Object)new KernelStateChangeEvent(this, KernelStateChangeEvent.convertKernelState(kse.getEnteredState())));
            }
        } else if (event instanceof NotificationPublicationEvent) {
            this.messageDisplay.display(((NotificationPublicationEvent)event).getNotification());
        } else if (event instanceof OperationModeChangeEvent) {
            this.handleOperationModeChange((OperationModeChangeEvent)event);
        } else if (event == ClientConnectionMode.OFFLINE) {
            this.eventBus.onEvent((Object)new KernelStateChangeEvent(this, KernelStateChangeEvent.State.DISCONNECTED));
        }
    }

    private void handleOperationModeChange(OperationModeChangeEvent evt) {
        if (evt.getNewMode() == OperationMode.OPERATING) {
            this.register();
        } else {
            this.release();
        }
    }

    private void processObjectEvent(TCSObjectEvent objectEvent) {
        LOG.debug("TCSObjectEvent received: {}", (Object)objectEvent);
        if (this.sharedPortal == null) {
            return;
        }
        if (objectEvent.getType() == TCSObjectEvent.Type.OBJECT_MODIFIED) {
            this.processObjectModifiedEvent(objectEvent.getCurrentObjectState());
        }
    }

    private void processObjectModifiedEvent(TCSObject<?> tcsObject) {
        if (tcsObject instanceof TransportOrder || tcsObject instanceof OrderSequence) {
            return;
        }
        ModelComponent modelComponent = this.modelManager.getModel().getModelComponent(tcsObject.getReference().getName());
        if (modelComponent == null) {
            LOG.debug("No model component found for {}", (Object)tcsObject.getName());
            return;
        }
        ProcessAdapter adapter = this.processAdapterUtil.processAdapterFor(modelComponent);
        adapter.updateModelProperties(tcsObject, modelComponent, this.modelManager.getModel(), (TCSObjectService)this.sharedPortal.getPortal().getPlantModelService());
    }
}

