/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.access.to.order.DestinationCreationTO;
import org.opentcs.access.to.order.TransportOrderCreationTO;
import org.opentcs.components.kernel.services.TransportOrderService;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.model.AbstractConnectableModelComponent;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOrderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TransportOrderUtil.class);
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public TransportOrderUtil(SharedKernelServicePortalProvider portalProvider) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
    }

    public void createTransportOrder(List<AbstractConnectableModelComponent> destModels, List<String> actions, long deadline, VehicleModel vModel, String category) {
        this.createTransportOrder(destModels, actions, new ArrayList<Map<String, String>>(), deadline, vModel, category);
    }

    public void createTransportOrder(List<AbstractConnectableModelComponent> destModels, List<String> actions, List<Map<String, String>> propertiesList, long deadline, VehicleModel vModel, String type) {
        Objects.requireNonNull(destModels, "locations");
        Objects.requireNonNull(actions, "actions");
        Objects.requireNonNull(propertiesList, "propertiesList");
        Preconditions.checkArgument((!destModels.stream().anyMatch(o -> !(o instanceof PointModel) && !(o instanceof LocationModel)) ? 1 : 0) != 0, (Object)"destModels have to be a PointModel or a Locationmodel");
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            TransportOrderService transportOrderService = sharedPortal.getPortal().getTransportOrderService();
            ArrayList<DestinationCreationTO> destinations = new ArrayList<DestinationCreationTO>();
            for (int i = 0; i < destModels.size(); ++i) {
                DestinationCreationTO destination;
                Location location;
                AbstractConnectableModelComponent locModel = destModels.get(i);
                String action = actions.get(i);
                Map<Object, Object> properties = new HashMap();
                if (!propertiesList.isEmpty()) {
                    properties = propertiesList.get(i);
                }
                if ((location = (Location)transportOrderService.fetchObject(Location.class, locModel.getName())) == null) {
                    Point point = (Point)transportOrderService.fetchObject(Point.class, locModel.getName());
                    destination = new DestinationCreationTO(point.getName(), action).withDestLocationName(point.getName());
                } else {
                    destination = new DestinationCreationTO(location.getName(), action).withDestLocationName(location.getName()).withProperties(properties);
                }
                destinations.add(destination);
            }
            transportOrderService.createTransportOrder(new TransportOrderCreationTO("TOrder-", destinations).withIncompleteName(true).withDeadline(Instant.ofEpochMilli(deadline)).withIntendedVehicleName(vModel == null ? null : vModel.getName()).withType(type));
            sharedPortal.getPortal().getDispatcherService().dispatch();
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }

    public void createTransportOrder(TransportOrder pattern) {
        Objects.requireNonNull(pattern, "pattern");
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            sharedPortal.getPortal().getTransportOrderService().createTransportOrder(new TransportOrderCreationTO("TOrder-", this.copyDestinations(pattern)).withIncompleteName(true).withDeadline(pattern.getDeadline()).withIntendedVehicleName(pattern.getIntendedVehicle() == null ? null : pattern.getIntendedVehicle().getName()).withType(pattern.getType()).withProperties(pattern.getProperties()));
            sharedPortal.getPortal().getDispatcherService().dispatch();
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }

    public void createTransportOrder(PointModel pointModel, VehicleModel vModel) {
        Objects.requireNonNull(pointModel, "point");
        Objects.requireNonNull(vModel, "vehicle");
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            if (sharedPortal.getPortal().getState() != Kernel.State.OPERATING) {
                return;
            }
            sharedPortal.getPortal().getTransportOrderService().createTransportOrder(new TransportOrderCreationTO("Move-", Collections.singletonList(new DestinationCreationTO(pointModel.getName(), "MOVE"))).withIncompleteName(true).withDeadline(Instant.now()).withIntendedVehicleName(vModel.getName()));
            sharedPortal.getPortal().getDispatcherService().dispatch();
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }

    private List<DestinationCreationTO> copyDestinations(TransportOrder original) {
        LinkedList<DestinationCreationTO> result = new LinkedList<DestinationCreationTO>();
        for (DriveOrder driveOrder : original.getAllDriveOrders()) {
            result.add(this.copyDestination(driveOrder));
        }
        return result;
    }

    private DestinationCreationTO copyDestination(DriveOrder driveOrder) {
        return new DestinationCreationTO(driveOrder.getDestination().getDestination().getName(), driveOrder.getDestination().getOperation()).withProperties(driveOrder.getDestination().getProperties());
    }
}

