/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange.adapter;

import java.util.Objects;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.model.elements.LocationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationLockAdapter
implements AttributesChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocationLockAdapter.class);
    private final LocationModel model;
    private final SharedKernelServicePortalProvider portalProvider;
    private final ApplicationState applicationState;
    private boolean lockedPreviously;

    public LocationLockAdapter(SharedKernelServicePortalProvider portalProvider, ApplicationState applicationState, LocationModel model) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.applicationState = Objects.requireNonNull(applicationState, "applicationState");
        this.model = Objects.requireNonNull(model, "model");
        this.lockedPreviously = this.isLocationLocked();
    }

    public void propertiesChanged(AttributesChangeEvent e) {
        if (e.getModel() != this.model) {
            return;
        }
        boolean locked = this.isLocationLocked();
        if (locked == this.lockedPreviously) {
            return;
        }
        this.lockedPreviously = locked;
        new Thread(() -> this.updateLockInKernel(locked)).start();
    }

    private boolean isLocationLocked() {
        return (Boolean)this.model.getPropertyLocked().getValue();
    }

    private void updateLockInKernel(boolean locked) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            Location location;
            KernelServicePortal portal = sharedPortal.getPortal();
            if (portal.getState() == Kernel.State.OPERATING && (location = (Location)portal.getPlantModelService().fetchObject(Location.class, this.model.getName())) != null && location.isLocked() != locked) {
                portal.getPlantModelService().updateLocationLock((TCSObjectReference)location.getReference(), locked);
            }
        }
        catch (ServiceUnavailableException exc) {
            LOG.warn("Could not connect to kernel", (Throwable)exc);
        }
    }
}

