/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange.adapter;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.access.CredentialsException;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.exchange.DriveOrderHistory;
import org.opentcs.guing.exchange.adapter.VehicleAdapter;
import org.opentcs.guing.model.FigureDecorationDetails;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.transport.orders.TransportOrdersContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpsDeskVehicleAdapter
extends VehicleAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OpsDeskVehicleAdapter.class);
    private final DriveOrderHistory driveOrderHistory;
    private final TransportOrdersContainer transportOrdersContainer;

    @Inject
    public OpsDeskVehicleAdapter(DriveOrderHistory driveOrderHistory, @Nonnull TransportOrdersContainer transportOrdersContainer) {
        this.driveOrderHistory = Objects.requireNonNull(driveOrderHistory, "driveOrderHistory");
        this.transportOrdersContainer = Objects.requireNonNull(transportOrdersContainer, "transportOrdersContainer");
    }

    protected void updateModelDriveOrder(TCSObjectService objectService, Vehicle vehicle, VehicleModel vehicleModel, SystemModel systemModel) throws CredentialsException {
        TransportOrder transportOrder = this.getTransportOrder(objectService, (TCSObjectReference<TransportOrder>)vehicle.getTransportOrder());
        if (transportOrder != null) {
            Set<FigureDecorationDetails> driveOrderComponents = this.getDriveOrderComponents(transportOrder.getCurrentDriveOrder(), vehicle.getRouteProgressIndex(), systemModel);
            for (FigureDecorationDetails figureDecorationDetails : driveOrderComponents) {
                figureDecorationDetails.addVehicleModel(vehicleModel);
            }
            Set finishedComponents = this.driveOrderHistory.updateDriveOrderComponents(vehicleModel.getName(), driveOrderComponents);
            for (FigureDecorationDetails component : finishedComponents) {
                component.removeVehicleModel(vehicleModel);
            }
            vehicleModel.setCurrentDriveOrderPath(this.getCurrentDriveOrderPath(transportOrder.getCurrentDriveOrder(), vehicle.getRouteProgressIndex(), systemModel));
            vehicleModel.setDriveOrderDestination(this.getCurrentDriveOrderDestination(transportOrder.getCurrentDriveOrder(), systemModel));
            vehicleModel.setDriveOrderState(transportOrder.getState());
        } else {
            Set finishedComponents = this.driveOrderHistory.updateDriveOrderComponents(vehicleModel.getName(), new HashSet());
            for (FigureDecorationDetails figureDecorationDetails : finishedComponents) {
                figureDecorationDetails.removeVehicleModel(vehicleModel);
            }
            vehicleModel.setCurrentDriveOrderPath(null);
            vehicleModel.setDriveOrderDestination(null);
        }
    }

    @Nullable
    private TransportOrder getTransportOrder(TCSObjectService objectService, TCSObjectReference<TransportOrder> ref) throws CredentialsException {
        if (ref == null) {
            return null;
        }
        return this.transportOrdersContainer.getTransportOrder(ref.getName()).orElse(null);
    }

    private PathModel getCurrentDriveOrderPath(@Nullable DriveOrder driveOrder, int routeProgressIndex, SystemModel systemModel) {
        if (driveOrder == null) {
            return null;
        }
        return driveOrder.getRoute().getSteps().stream().skip(Math.max(0, routeProgressIndex + 1)).map(step -> step.getPath()).filter(path -> path != null).findFirst().map(path -> systemModel.getPathModel(path.getName())).orElse(null);
    }

    private PointModel getCurrentDriveOrderDestination(@Nullable DriveOrder driveOrder, SystemModel systemModel) {
        if (driveOrder == null) {
            return null;
        }
        return systemModel.getPointModel(driveOrder.getDestination().getDestination().getName());
    }

    private Set<FigureDecorationDetails> getDriveOrderComponents(@Nullable DriveOrder driveOrder, int routeProgressIndex, SystemModel systemModel) {
        if (driveOrder == null) {
            return new HashSet<FigureDecorationDetails>();
        }
        HashSet<FigureDecorationDetails> result = new HashSet<FigureDecorationDetails>();
        driveOrder.getRoute().getSteps().stream().skip(routeProgressIndex + 1).flatMap(step -> Stream.of(step.getPath(), step.getDestinationPoint())).filter(pointOrPath -> pointOrPath != null).forEach(pointOrPath -> {
            if (pointOrPath instanceof Point) {
                result.add((FigureDecorationDetails)systemModel.getPointModel(pointOrPath.getName()));
            } else if (pointOrPath instanceof Path) {
                result.add((FigureDecorationDetails)systemModel.getPathModel(pointOrPath.getName()));
            }
        });
        TCSObjectReference ref = driveOrder.getDestination().getDestination();
        if (ref.getReferentClass().isAssignableFrom(Location.class)) {
            result.add((FigureDecorationDetails)systemModel.getLocationModel(ref.getName()));
        }
        return result;
    }
}

