/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.exchange.adapter;

import java.util.Objects;
import java.util.Set;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.model.elements.VehicleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleAllowedOrderTypesAdapter
implements AttributesChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleAllowedOrderTypesAdapter.class);
    private final VehicleModel model;
    private final SharedKernelServicePortalProvider portalProvider;
    private final ApplicationState applicationState;
    private Set<String> previousAllowedOrderTypes;

    public VehicleAllowedOrderTypesAdapter(SharedKernelServicePortalProvider portalProvider, ApplicationState applicationState, VehicleModel model) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.applicationState = Objects.requireNonNull(applicationState, "applicationState");
        this.model = Objects.requireNonNull(model, "model");
        this.previousAllowedOrderTypes = this.getAllowedOrderTypes();
    }

    public void propertiesChanged(AttributesChangeEvent e) {
        if (e.getModel() != this.model) {
            return;
        }
        Set<String> allowedOrderTypes = this.getAllowedOrderTypes();
        if (this.previousAllowedOrderTypes.size() == allowedOrderTypes.size() && this.previousAllowedOrderTypes.containsAll(allowedOrderTypes)) {
            LOG.debug("Ignoring vehicle properties update because the allowed order types did not change");
            return;
        }
        this.previousAllowedOrderTypes = allowedOrderTypes;
        new Thread(() -> this.updateAllowedOrderTypesInKernel(allowedOrderTypes)).start();
    }

    private Set<String> getAllowedOrderTypes() {
        return this.model.getPropertyAllowedOrderTypes().getItems();
    }

    private void updateAllowedOrderTypesInKernel(Set<String> allowedOrderTypes) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            KernelServicePortal portal = sharedPortal.getPortal();
            if (portal.getState() == Kernel.State.OPERATING) {
                Vehicle vehicle = (Vehicle)portal.getVehicleService().fetchObject(Vehicle.class, this.model.getName());
                if (vehicle.getAllowedOrderTypes().size() == allowedOrderTypes.size() && vehicle.getAllowedOrderTypes().containsAll(allowedOrderTypes)) {
                    LOG.debug("Ignoring vehicle properties update. Already up do date.");
                    return;
                }
                portal.getVehicleService().updateVehicleAllowedOrderTypes(vehicle.getReference(), allowedOrderTypes);
            }
        }
        catch (ServiceUnavailableException exc) {
            LOG.warn("Could not connect to kernel", (Throwable)exc);
        }
    }
}

