/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.peripherals.jobs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.guing.peripherals.jobs.PeripheralJobTableModel;
import org.opentcs.guing.peripherals.jobs.PeripheralJobsContainer;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.gui.StringTableCellRenderer;

public class PeripheralJobsContainerPanel
extends JPanel {
    private final PeripheralJobsContainer peripheralJobsContainer;
    private JTable table;
    private PeripheralJobTableModel tableModel;

    @Inject
    public PeripheralJobsContainerPanel(PeripheralJobsContainer peripheralJobsContainer) {
        this.peripheralJobsContainer = Objects.requireNonNull(peripheralJobsContainer, "peripheralJobsContainer");
        this.initComponents();
    }

    public void initView() {
        this.tableModel.containerInitialized(this.peripheralJobsContainer.getPeripheralJobs());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.initPeripheralJobTable();
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initPeripheralJobTable() {
        this.tableModel = new PeripheralJobTableModel();
        this.peripheralJobsContainer.addListener(this.tableModel);
        this.table = new JTable(this.tableModel);
        TableRowSorter<PeripheralJobTableModel> sorter = new TableRowSorter<PeripheralJobTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(6, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(6)));
        StringTableCellRenderer renderer = new StringTableCellRenderer(reference -> {
            if (reference == null) {
                return "-";
            }
            return reference.getName();
        });
        this.table.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)renderer);
        this.table.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)renderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    PeripheralJobsContainerPanel.this.showSelectedJob();
                }
                if (evt.getButton() == 3 && PeripheralJobsContainerPanel.this.table.getSelectedRow() != -1) {
                    PeripheralJobsContainerPanel.this.showPopupMenuForSelectedJob(evt.getX(), evt.getY());
                }
            }
        });
    }

    private void showSelectedJob() {
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex > -1) {
            PeripheralJob peripheralJob = this.tableModel.getEntryAt(this.table.convertRowIndexToModel(rowIndex));
        }
    }

    private void showPopupMenuForSelectedJob(int x, int y) {
        boolean singleRowSelected = this.table.getSelectedRowCount() <= 1;
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.peripheralJobs");
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(bundle.getString("peripheralJobsContainerPanel.table_peripheralJobs.popupMenuItem_showDetails.text"));
        item.setEnabled(singleRowSelected);
        item.addActionListener(event -> this.showSelectedJob());
        menu.show(this.table, x, y);
    }
}

