/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.guing.transport.StandardObjectHistoryEntryFormatter;

public class CompositeObjectHistoryEntryFormatter
implements ObjectHistoryEntryFormatter {
    private final List<ObjectHistoryEntryFormatter> formatters = new ArrayList<ObjectHistoryEntryFormatter>();

    @Inject
    public CompositeObjectHistoryEntryFormatter(Set<ObjectHistoryEntryFormatter> customFormatters) {
        for (ObjectHistoryEntryFormatter formatter : customFormatters) {
            this.formatters.add(formatter);
        }
        this.formatters.add(new StandardObjectHistoryEntryFormatter());
        this.formatters.add(this::fallbackFormat);
    }

    public Optional<String> apply(ObjectHistory.Entry entry) {
        return this.formatters.stream().map(formatter -> (Optional)formatter.apply((Object)entry)).filter(result -> result.isPresent()).map(result -> (String)result.get()).findFirst();
    }

    private Optional<String> fallbackFormat(ObjectHistory.Entry entry) {
        return Optional.of("eventCode: '" + entry.getEventCode() + "', supplement: '" + entry.getSupplement().toString() + '\'');
    }
}

