/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.EditDriveOrderPanel;
import org.opentcs.guing.components.dialogs.StandardContentDialog;
import org.opentcs.guing.model.AbstractConnectableModelComponent;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.transport.OrderTypeSuggestionsPool;

public class CreateTransportOrderPanel
extends DialogContent {
    private final ResourceBundle bundle = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.dialogs.createTransportOrder");
    private long fSelectedDeadline;
    private final List<AbstractConnectableModelComponent> fDestinationModels = new ArrayList<AbstractConnectableModelComponent>();
    private final List<String> fActions = new ArrayList<String>();
    private final List<Map<String, String>> fPropertiesList = new ArrayList<Map<String, String>>();
    private final List<String> fPossibleTypes;
    private final List<VehicleModel> fVehicles;
    private final ModelManager fModelManager;
    private TransportOrder fPattern;
    private JButton addButton;
    private JLabel dateLabel;
    private JTextField dateTextField;
    private JPanel deadlinePanel;
    private JScrollPane driveOrdersScrollPane;
    private JTable driveOrdersTable;
    private JButton editButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private JPanel stationsPanel;
    private JLabel timeLabel;
    private JTextField timeTextField;
    private JComboBox<String> typeComboBox;
    private JLabel typeLabel;
    private JPanel typePanel;
    private JComboBox<String> vehicleComboBox;
    private JLabel vehicleLabel;
    private JPanel vehiclePanel;

    @Inject
    public CreateTransportOrderPanel(ModelManager modelManager, OrderTypeSuggestionsPool orderTypeSuggestionsPool) {
        this.fModelManager = Objects.requireNonNull(modelManager, "modelManager");
        Objects.requireNonNull(orderTypeSuggestionsPool, "orderTypeSuggestionsPool");
        this.initComponents();
        Object[] columnNames = new Object[]{this.bundle.getString("createTransportOrderPanel.table_driveOrdersTable.column_location.headerText"), this.bundle.getString("createTransportOrderPanel.table_driveOrdersTable.column_action.headerText")};
        DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
        model.setColumnIdentifiers(columnNames);
        this.driveOrdersTable.getSelectionModel().addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting()) {
                this.updateButtons();
            }
        });
        this.fVehicles = this.fModelManager.getModel().getVehicleModels();
        Collections.sort(this.fVehicles, (v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName()));
        this.fPossibleTypes = new ArrayList<String>(orderTypeSuggestionsPool.getTypeSuggestions());
        this.initTitle();
    }

    private void initTitle() {
        this.setDialogTitle(this.bundle.getString("transportOrdersContainerPanel.dialog.title"));
    }

    public List<AbstractConnectableModelComponent> getDestinationModels() {
        return this.fDestinationModels;
    }

    public List<String> getActions() {
        return this.fActions;
    }

    public List<Map<String, String>> getPropertiesList() {
        return this.fPropertiesList;
    }

    public long getSelectedDeadline() {
        return this.fSelectedDeadline;
    }

    public VehicleModel getSelectedVehicle() {
        if (this.vehicleComboBox.getSelectedIndex() == 0) {
            return null;
        }
        return this.fVehicles.get(this.vehicleComboBox.getSelectedIndex() - 1);
    }

    public String getSelectedType() {
        if (this.typeComboBox.getSelectedItem() == null) {
            return "-";
        }
        return this.typeComboBox.getSelectedItem().toString();
    }

    public void update() {
        try {
            this.updateFailed = false;
            SimpleDateFormat deadlineFormat = new SimpleDateFormat("dd.MM.yyyyHH:mm");
            Date date = deadlineFormat.parse(this.dateTextField.getText() + this.timeTextField.getText());
            ZonedDateTime deadline = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            this.fSelectedDeadline = deadline.toInstant().toEpochMilli();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.bundle.getString("createTransportOrderPanel.optionPane_dateTimeParseError.message"), this.bundle.getString("createTransportOrderPanel.optionPane_dateTimeParseError.title"), 0);
            this.updateFailed = true;
        }
        if (this.fDestinationModels.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.bundle.getString("createTransportOrderPanel.optionPane_noOrderError.message"), this.bundle.getString("createTransportOrderPanel.optionPane_noOrderError.title"), 0);
            this.updateFailed = true;
        }
    }

    public void initFields() {
        this.vehicleComboBox.addItem(this.bundle.getString("createTransportOrderPanel.comboBox_automatic.text"));
        for (VehicleModel vehicleModel : this.fVehicles) {
            this.vehicleComboBox.addItem(vehicleModel.getName());
        }
        for (String tag : this.fPossibleTypes) {
            this.typeComboBox.addItem(tag);
        }
        ZonedDateTime newDeadline = ZonedDateTime.now(ZoneId.systemDefault()).plusHours(1L);
        this.dateTextField.setText(newDeadline.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
        this.timeTextField.setText(newDeadline.format(DateTimeFormatter.ofPattern("HH:mm")));
        if (this.fPattern != null) {
            newDeadline = ZonedDateTime.ofInstant(this.fPattern.getDeadline(), ZoneId.systemDefault());
            this.dateTextField.setText(newDeadline.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
            this.timeTextField.setText(newDeadline.format(DateTimeFormatter.ofPattern("HH:mm")));
            if (this.fPattern.getIntendedVehicle() != null) {
                this.vehicleComboBox.setSelectedItem(this.fPattern.getIntendedVehicle().getName());
            }
            this.typeComboBox.setSelectedItem(this.fPattern.getType());
            LinkedList driveOrders = new LinkedList();
            driveOrders.addAll(this.fPattern.getAllDriveOrders());
            DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
            for (DriveOrder o : driveOrders) {
                String destination = o.getDestination().getDestination().getName();
                String action = o.getDestination().getOperation();
                Map properties = o.getDestination().getProperties();
                Object[] row = new String[]{destination, action};
                model.addRow(row);
                LocationModel destModel = this.fModelManager.getModel().getLocationModel(destination);
                if (destModel == null) {
                    destModel = this.fModelManager.getModel().getPointModel(destination);
                }
                this.fDestinationModels.add((AbstractConnectableModelComponent)destModel);
                this.fActions.add(action);
                this.fPropertiesList.add(properties);
            }
        }
        this.updateButtons();
    }

    public void setPattern(TransportOrder t) {
        this.fPattern = t;
    }

    private void updateButtons() {
        boolean state = this.driveOrdersTable.getSelectedRow() != -1;
        this.editButton.setEnabled(state);
        this.removeButton.setEnabled(state);
        this.moveUpButton.setEnabled(state);
        this.moveDownButton.setEnabled(state);
        if (this.driveOrdersTable.getRowCount() == this.driveOrdersTable.getSelectedRow() + 1) {
            this.moveDownButton.setEnabled(false);
        }
        if (this.driveOrdersTable.getSelectedRow() == 0) {
            this.moveUpButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.stationsPanel = new JPanel();
        this.driveOrdersScrollPane = new JScrollPane();
        this.driveOrdersTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.deadlinePanel = new JPanel();
        this.dateLabel = new JLabel();
        this.dateTextField = new JTextField();
        this.timeLabel = new JLabel();
        this.timeTextField = new JTextField();
        this.typePanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.vehiclePanel = new JPanel();
        this.vehicleLabel = new JLabel();
        this.vehicleComboBox = new JComboBox();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/createTransportOrder");
        this.stationsPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("createTransportOrderPanel.panel_stations.border.title")));
        GridBagLayout stationsPanelLayout = new GridBagLayout();
        stationsPanelLayout.columnWidths = new int[]{0, 5, 0};
        stationsPanelLayout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0, 5, 0};
        this.stationsPanel.setLayout(stationsPanelLayout);
        this.driveOrdersScrollPane.setPreferredSize(new Dimension(200, 200));
        this.driveOrdersTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Station", "Aktion"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.driveOrdersScrollPane.setViewportView(this.driveOrdersTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.stationsPanel.add((Component)this.driveOrdersScrollPane, gridBagConstraints);
        this.addButton.setFont(this.addButton.getFont());
        this.addButton.setText(bundle.getString("createTransportOrderPanel.button_add.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTransportOrderPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.stationsPanel.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setFont(this.editButton.getFont());
        this.editButton.setText(bundle.getString("createTransportOrderPanel.button_edit.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTransportOrderPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.stationsPanel.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setFont(this.removeButton.getFont());
        this.removeButton.setText(bundle.getString("createTransportOrderPanel.button_delete.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTransportOrderPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.stationsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.moveUpButton.setFont(this.moveUpButton.getFont());
        this.moveUpButton.setText(bundle.getString("createTransportOrderPanel.button_up.text"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTransportOrderPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.stationsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setFont(this.moveDownButton.getFont());
        this.moveDownButton.setText(bundle.getString("createTransportOrderPanel.button_moveDown.text"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateTransportOrderPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.stationsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.add(this.stationsPanel);
        this.deadlinePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("createTransportOrderPanel.panel_deadline.border.title")));
        GridBagLayout deadlinePanelLayout = new GridBagLayout();
        deadlinePanelLayout.columnWidths = new int[]{0, 5, 0, 5, 0, 5, 0};
        deadlinePanelLayout.rowHeights = new int[]{0};
        this.deadlinePanel.setLayout(deadlinePanelLayout);
        this.dateLabel.setFont(this.dateLabel.getFont());
        this.dateLabel.setText(bundle.getString("createTransportOrderPanel.label_date.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.deadlinePanel.add((Component)this.dateLabel, gridBagConstraints);
        this.dateTextField.setColumns(10);
        this.dateTextField.setFont(this.dateTextField.getFont());
        this.dateTextField.setText("31.12.2099");
        this.dateTextField.setToolTipText("Geben Sie das Datum im Format TT.MM.JJJJ ein!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.deadlinePanel.add((Component)this.dateTextField, gridBagConstraints);
        this.timeLabel.setFont(this.timeLabel.getFont());
        this.timeLabel.setText(bundle.getString("createTransportOrderPanel.label_time.text"));
        this.timeLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.deadlinePanel.add((Component)this.timeLabel, gridBagConstraints);
        this.timeTextField.setColumns(10);
        this.timeTextField.setFont(this.timeTextField.getFont());
        this.timeTextField.setText("23:59");
        this.timeTextField.setToolTipText("Geben Sie die Uhrzeit im Format HH:MM ein!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.deadlinePanel.add((Component)this.timeTextField, gridBagConstraints);
        this.add(this.deadlinePanel);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("createTransportOrderPanel.panel_type.border.title")));
        GridBagLayout typePanelLayout = new GridBagLayout();
        typePanelLayout.columnWidths = new int[]{0, 5, 0};
        typePanelLayout.rowHeights = new int[]{0};
        this.typePanel.setLayout(typePanelLayout);
        this.typeLabel.setFont(this.typeLabel.getFont());
        this.typeLabel.setText(bundle.getString("createTransportOrderPanel.label_type.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.typePanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setEditable(true);
        this.typeComboBox.setFont(this.typeComboBox.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.typePanel.add(this.typeComboBox, gridBagConstraints);
        this.add(this.typePanel);
        this.vehiclePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("createTransportOrderPanel.panel_vehicle.border.title")));
        GridBagLayout vehiclePanelLayout = new GridBagLayout();
        vehiclePanelLayout.columnWidths = new int[]{0, 5, 0};
        vehiclePanelLayout.rowHeights = new int[]{0};
        this.vehiclePanel.setLayout(vehiclePanelLayout);
        this.vehicleLabel.setFont(this.vehicleLabel.getFont());
        this.vehicleLabel.setText(bundle.getString("createTransportOrderPanel.label_vehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.vehiclePanel.add((Component)this.vehicleLabel, gridBagConstraints);
        this.vehicleComboBox.setFont(this.vehicleComboBox.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.vehiclePanel.add(this.vehicleComboBox, gridBagConstraints);
        this.add(this.vehiclePanel);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int index = this.driveOrdersTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        if (index == this.driveOrdersTable.getRowCount() - 1) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
        model.moveRow(index, index, index + 1);
        this.driveOrdersTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
        AbstractConnectableModelComponent location = this.fDestinationModels.remove(index);
        this.fDestinationModels.add(index + 1, location);
        String action = this.fActions.remove(index);
        this.fActions.add(index + 1, action);
        Map<String, String> properties = this.fPropertiesList.remove(index);
        this.fPropertiesList.add(index + 1, properties);
        this.updateButtons();
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int index = this.driveOrdersTable.getSelectedRow();
        if (index <= 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
        model.moveRow(index, index, index - 1);
        this.driveOrdersTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
        AbstractConnectableModelComponent location = this.fDestinationModels.remove(index);
        this.fDestinationModels.add(index - 1, location);
        String action = this.fActions.remove(index);
        this.fActions.add(index - 1, action);
        Map<String, String> properties = this.fPropertiesList.remove(index);
        this.fPropertiesList.add(index - 1, properties);
        this.updateButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.driveOrdersTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.fDestinationModels.remove(index);
        this.fActions.remove(index);
        this.fPropertiesList.remove(index);
        DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
        model.removeRow(index);
        this.updateButtons();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.driveOrdersTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        AbstractConnectableModelComponent location = this.fDestinationModels.get(index);
        String action = this.fActions.get(index);
        EditDriveOrderPanel contentPanel = new EditDriveOrderPanel(this.fModelManager.getModel().getLocationModels(), location, action);
        StandardContentDialog dialog = new StandardContentDialog((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (DialogContent)contentPanel);
        dialog.setVisible(true);
        Optional<LocationModel> locModel = contentPanel.getSelectedLocation();
        Optional<String> act = contentPanel.getSelectedAction();
        if (dialog.getReturnStatus() == 1 && locModel.isPresent() && act.isPresent()) {
            location = (AbstractConnectableModelComponent)locModel.get();
            action = act.get();
            this.driveOrdersTable.setValueAt(location.getName(), index, 0);
            this.driveOrdersTable.setValueAt(action, index, 1);
            this.fDestinationModels.set(index, location);
            this.fActions.set(index, action);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        EditDriveOrderPanel contentPanel = new EditDriveOrderPanel(this.fModelManager.getModel().getLocationModels());
        StandardContentDialog dialog = new StandardContentDialog((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (DialogContent)contentPanel);
        dialog.setVisible(true);
        Optional<LocationModel> locModel = contentPanel.getSelectedLocation();
        Optional<String> act = contentPanel.getSelectedAction();
        if (dialog.getReturnStatus() == 1 && locModel.isPresent() && act.isPresent()) {
            int index = this.driveOrdersTable.getRowCount();
            LocationModel location = locModel.get();
            String action = act.get();
            Object[] row = new String[]{location.getName(), action};
            DefaultTableModel model = (DefaultTableModel)this.driveOrdersTable.getModel();
            model.addRow(row);
            this.fDestinationModels.add((AbstractConnectableModelComponent)location);
            this.fActions.add(action);
            this.fPropertiesList.add(new HashMap());
            this.driveOrdersTable.setRowSelectionInterval(index, index);
            this.updateButtons();
        }
    }
}

