/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.InputValidationListener;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.PointModel;

public class PointPanel
extends DialogContent {
    protected List<PointModel> fItems;
    private final List<InputValidationListener> validationListeners = new LinkedList<InputValidationListener>();
    private JComboBox<String> itemsComboBox;
    private JLabel itemsLabel;

    public PointPanel(List<PointModel> items) {
        this.initComponents();
        this.fItems = items;
        Collections.sort(this.fItems, this.getComparator());
        ArrayList<String> names = new ArrayList<String>();
        for (PointModel pointModel : this.fItems) {
            names.add(pointModel.getName());
        }
        this.itemsComboBox.setModel(new DefaultComboBoxModel(new Vector(names)));
        JTextField textField = (JTextField)this.itemsComboBox.getEditor().getEditorComponent();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PointPanel.this.verify();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PointPanel.this.verify();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PointPanel.this.verify();
            }
        });
    }

    public void addInputValidationListener(InputValidationListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.validationListeners.add(listener);
        this.verify();
    }

    public ModelComponent getSelectedItem() {
        int index = this.itemsComboBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (ModelComponent)this.fItems.get(index);
    }

    public void update() {
    }

    public void initFields() {
    }

    protected final Comparator<ModelComponent> getComparator() {
        return new Comparator<ModelComponent>(){

            @Override
            public int compare(ModelComponent item1, ModelComponent item2) {
                String s1 = item1.getName();
                String s2 = item2.getName();
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
                return s1.compareTo(s2);
            }
        };
    }

    private void verify() {
        JTextField textField = (JTextField)this.itemsComboBox.getEditor().getEditorComponent();
        String inputText = textField.getText();
        for (PointModel pointModel : this.fItems) {
            if (!pointModel.getName().equals(inputText)) continue;
            this.inputValidationSuccessful(true);
            return;
        }
        this.inputValidationSuccessful(false);
    }

    private void inputValidationSuccessful(boolean success) {
        for (InputValidationListener valListener : this.validationListeners) {
            valListener.inputValidationSuccessful(success);
        }
    }

    private void initComponents() {
        this.itemsLabel = new JLabel();
        this.itemsComboBox = new JComboBox();
        this.setLayout(new FlowLayout(0, 10, 5));
        this.itemsLabel.setFont(this.itemsLabel.getFont());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/vehiclePopup");
        this.itemsLabel.setText(bundle.getString("pointPanel.label_points.text"));
        this.add(this.itemsLabel);
        this.itemsComboBox.setEditable(true);
        this.itemsComboBox.setFont(this.itemsComboBox.getFont());
        this.add(this.itemsComboBox);
    }
}

