/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport;

import java.util.Objects;
import java.util.Optional;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class StandardObjectHistoryEntryFormatter
implements ObjectHistoryEntryFormatter {
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail");

    public Optional<String> apply(ObjectHistory.Entry entry) {
        Objects.requireNonNull(entry, "entry");
        switch (entry.getEventCode()) {
            case "tcsHistory:orderCreated": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderCreated.text"));
            }
            case "tcsHistory:orderDispatchingDeferred": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderDispatchingDeferred.text") + " " + entry.getSupplement().toString());
            }
            case "tcsHistory:orderDispatchingResumed": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderDispatchingResumed.text"));
            }
            case "tcsHistory:orderAssignedToVehicle": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderAssignedToVehicle.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderReservedForVehicle": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderReservedForVehicle.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderProcVehicleChanged": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderProcVehicleChanged.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderFinishedDriveOrder": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_driveOrderFinished.text"));
            }
            case "tcsHistory:orderReachedFinalState": {
                return Optional.of(this.bundle.getString("standardObjectHistoryEntryFormatter.code_orderReachedFinalState.text"));
            }
        }
        return Optional.empty();
    }
}

