/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport.orders;

import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.transport.CompositeObjectHistoryEntryFormatter;
import org.opentcs.guing.transport.UneditableTableModel;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class TransportOrderView
extends DialogContent {
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final ObjectHistoryEntryFormatter historyEntryFormatter;
    private final TransportOrder fTransportOrder;
    private JLabel costsLabel;
    private JTextField costsTextField;
    private JLabel createdLabel;
    private JTextField createdTextField;
    private JLabel deadlineLabel;
    private JTextField deadlineTextField;
    private JPanel dependenciesPanel;
    private JScrollPane dependenciesScrollPane;
    private JTable dependenciesTable;
    private JLabel dispensableLabel;
    private JTextField dispensableTextField;
    private JTable driveOrderPropertiesTable;
    private JPanel driveOrdersPanel;
    private JPanel driveOrdersPropertiesPanel;
    private JScrollPane driveOrdersPropertiesScrollPane;
    private JScrollPane driveOrdersScrollPane;
    private JTable driveOrdersTable;
    private JLabel finishedLabel;
    private JTextField finishedTextField;
    private JPanel generalPanel;
    private JPanel historyPanel;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel propertiesPanel;
    private JScrollPane propertiesScrollPane;
    private JTable propertiesTable;
    private JLabel reservationTokenLabel;
    private JTextField reservationTokenTextField;
    private JPanel routePanel;
    private JScrollPane routeScrollPane;
    private JTable routeTable;
    private JLabel typeLabel;
    private JTextField typeTextField;
    private JLabel vehicleLabel;
    private JTextField vehicleTextField;

    @Inject
    public TransportOrderView(@Assisted TransportOrder order, CompositeObjectHistoryEntryFormatter historyEntryFormatter) {
        this.fTransportOrder = Objects.requireNonNull(order, "order");
        this.historyEntryFormatter = Objects.requireNonNull(historyEntryFormatter, "historyEntryFormatter");
        this.initComponents();
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.title"));
    }

    public void update() {
    }

    public final void initFields() {
        this.nameTextField.setText(this.fTransportOrder.getName());
        this.createdTextField.setText(TIMESTAMP_FORMAT.format(Date.from(this.fTransportOrder.getCreationTime())));
        this.finishedTextField.setText(!this.fTransportOrder.getFinishedTime().equals(Instant.MAX) ? TIMESTAMP_FORMAT.format(Date.from(this.fTransportOrder.getFinishedTime())) : "-");
        this.deadlineTextField.setText(!this.fTransportOrder.getDeadline().equals(Instant.MAX) ? TIMESTAMP_FORMAT.format(Date.from(this.fTransportOrder.getDeadline())) : "-");
        this.dispensableTextField.setText(Boolean.toString(this.fTransportOrder.isDispensable()));
        if (this.fTransportOrder.getProcessingVehicle() != null) {
            this.vehicleTextField.setText(this.fTransportOrder.getProcessingVehicle().getName());
        }
        this.typeTextField.setText(this.fTransportOrder.getType());
        this.reservationTokenTextField.setText(this.fTransportOrder.getPeripheralReservationToken());
        this.propertiesTable.setModel(this.createPropertiesTableModel());
        this.driveOrdersTable.setModel(this.createDriveOrdersTableModel());
        this.driveOrdersTable.getSelectionModel().addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting()) {
                this.driveOrdersTableSelectionChanged();
            }
        });
        this.driveOrdersScrollPane.setPreferredSize(new Dimension(200, 150));
        this.driveOrderPropertiesTable.setModel(this.createDriveOrderPropertiesTableModel());
        this.routeTable.setModel(this.createRouteTableModel());
        this.dependenciesTable.setModel(this.createDependenciesTableModel());
        this.historyTable.setModel(this.createHistoryTableModel());
        this.historyTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.historyTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.historyTable.getColumnModel().getColumn(1).setCellRenderer(new ToolTipCellRenderer());
    }

    private TableModel createPropertiesTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_properties.column_propertiesKey.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_properties.column_propertiesValue.headerText")});
        for (Map.Entry entry : this.fTransportOrder.getProperties().entrySet()) {
            tableModel.addRow(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        return tableModel;
    }

    private TableModel createDriveOrdersTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_driveOrderProperties.column_target.headerText"), "Operation", "Status"});
        for (DriveOrder o : this.fTransportOrder.getAllDriveOrders()) {
            Object[] row = new String[]{o.getDestination().getDestination().getName(), o.getDestination().getOperation(), o.getState().toString()};
            tableModel.addRow(row);
        }
        return tableModel;
    }

    private TableModel createDriveOrderPropertiesTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_driveOrderProperties.column_driveOrderPropertiesKey.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_driveOrderProperties.column_driveOrderPropertiesValue.headerText")});
        return tableModel;
    }

    private TableModel createRouteTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_route.column_route.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_routeTable.column_destination.headerText")});
        return tableModel;
    }

    private TableModel createDependenciesTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_dependencies.column_dependentTransportOrder.headerText")});
        for (TCSObjectReference refTransportOrder : this.fTransportOrder.getDependencies()) {
            Object[] row = new String[]{refTransportOrder.getName()};
            tableModel.addRow(row);
        }
        return tableModel;
    }

    private TableModel createHistoryTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_history.column_timestamp.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrderView.table_history.column_event.headerText")});
        for (ObjectHistory.Entry entry : this.fTransportOrder.getHistory().getEntries()) {
            tableModel.addRow(new String[]{TIMESTAMP_FORMAT.format(Date.from(entry.getTimestamp())), (String)((Optional)this.historyEntryFormatter.apply((Object)entry)).get()});
        }
        return tableModel;
    }

    private void driveOrdersTableSelectionChanged() {
        DriveOrder driveOrder = (DriveOrder)this.fTransportOrder.getAllDriveOrders().get(this.driveOrdersTable.getSelectedRow());
        DefaultTableModel routeTableModel = (DefaultTableModel)this.routeTable.getModel();
        DefaultTableModel driveOrderPropsTableModel = (DefaultTableModel)this.driveOrderPropertiesTable.getModel();
        while (routeTableModel.getRowCount() > 0) {
            routeTableModel.removeRow(0);
        }
        while (driveOrderPropsTableModel.getRowCount() > 0) {
            driveOrderPropsTableModel.removeRow(0);
        }
        for (Map.Entry entry : driveOrder.getDestination().getProperties().entrySet()) {
            driveOrderPropsTableModel.addRow(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        if (driveOrder.getRoute() == null) {
            return;
        }
        this.costsTextField.setText(Long.toString(driveOrder.getRoute().getCosts()));
        for (Route.Step step : driveOrder.getRoute().getSteps()) {
            routeTableModel.addRow(new String[]{step.getPath() == null ? "" : step.getPath().getName(), step.getDestinationPoint().getName()});
        }
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.createdLabel = new JLabel();
        this.createdTextField = new JTextField();
        this.finishedLabel = new JLabel();
        this.finishedTextField = new JTextField();
        this.deadlineLabel = new JLabel();
        this.deadlineTextField = new JTextField();
        this.vehicleLabel = new JLabel();
        this.vehicleTextField = new JTextField();
        this.dispensableLabel = new JLabel();
        this.dispensableTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeTextField = new JTextField();
        this.reservationTokenLabel = new JLabel();
        this.reservationTokenTextField = new JTextField();
        this.dependenciesPanel = new JPanel();
        this.dependenciesScrollPane = new JScrollPane();
        this.dependenciesTable = new JTable();
        this.propertiesPanel = new JPanel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.historyPanel = new JPanel();
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.driveOrdersPanel = new JPanel();
        this.driveOrdersScrollPane = new JScrollPane();
        this.driveOrdersTable = new JTable();
        this.driveOrdersPropertiesPanel = new JPanel();
        this.driveOrdersPropertiesScrollPane = new JScrollPane();
        this.driveOrderPropertiesTable = new JTable();
        this.routePanel = new JPanel();
        this.routeScrollPane = new JScrollPane();
        this.routeTable = new JTable();
        this.costsLabel = new JLabel();
        this.costsTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/transportOrderDetail");
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_general.border.title")));
        this.generalPanel.setLayout(new GridBagLayout());
        this.nameLabel.setFont(this.nameLabel.getFont());
        this.nameLabel.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setEditable(false);
        this.nameTextField.setColumns(10);
        this.nameTextField.setFont(this.nameTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.createdLabel.setFont(this.createdLabel.getFont());
        this.createdLabel.setText(bundle.getString("transportOrderView.label_created.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.createdLabel, gridBagConstraints);
        this.createdTextField.setEditable(false);
        this.createdTextField.setColumns(10);
        this.createdTextField.setFont(this.createdTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.createdTextField, gridBagConstraints);
        this.finishedLabel.setFont(this.finishedLabel.getFont());
        this.finishedLabel.setText(bundle.getString("transportOrderView.label_finished.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.generalPanel.add((Component)this.finishedLabel, gridBagConstraints);
        this.finishedTextField.setEditable(false);
        this.finishedTextField.setColumns(10);
        this.finishedTextField.setFont(this.finishedTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.finishedTextField, gridBagConstraints);
        this.deadlineLabel.setFont(this.deadlineLabel.getFont());
        this.deadlineLabel.setText(bundle.getString("transportOrderView.label_deadline.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.deadlineLabel, gridBagConstraints);
        this.deadlineTextField.setEditable(false);
        this.deadlineTextField.setColumns(10);
        this.deadlineTextField.setFont(this.deadlineTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.deadlineTextField, gridBagConstraints);
        this.vehicleLabel.setFont(this.vehicleLabel.getFont());
        this.vehicleLabel.setText(bundle.getString("transportOrderView.label_vehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.generalPanel.add((Component)this.vehicleLabel, gridBagConstraints);
        this.vehicleTextField.setEditable(false);
        this.vehicleTextField.setColumns(10);
        this.vehicleTextField.setFont(this.vehicleTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.vehicleTextField, gridBagConstraints);
        this.dispensableLabel.setFont(this.dispensableLabel.getFont());
        this.dispensableLabel.setText(bundle.getString("transportOrderView.label_dispensable.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.dispensableLabel, gridBagConstraints);
        this.dispensableTextField.setEditable(false);
        this.dispensableTextField.setColumns(10);
        this.dispensableTextField.setFont(this.dispensableTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.dispensableTextField, gridBagConstraints);
        this.typeLabel.setFont(this.typeLabel.getFont());
        this.typeLabel.setText(bundle.getString("transportOrderView.label_type.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.generalPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeTextField.setEditable(false);
        this.typeTextField.setColumns(10);
        this.typeTextField.setFont(this.typeTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.typeTextField, gridBagConstraints);
        this.reservationTokenLabel.setText(bundle.getString("transportOrderView.label_reservationToken.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.reservationTokenLabel, gridBagConstraints);
        this.reservationTokenTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.generalPanel.add((Component)this.reservationTokenTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.add(this.generalPanel, gridBagConstraints);
        this.dependenciesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_dependencies.border.title")));
        this.dependenciesPanel.setLayout(new BorderLayout());
        this.dependenciesScrollPane.setPreferredSize(new Dimension(150, 100));
        this.dependenciesTable.setFont(this.dependenciesTable.getFont());
        this.dependenciesTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.dependenciesScrollPane.setViewportView(this.dependenciesTable);
        this.dependenciesPanel.add((Component)this.dependenciesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.dependenciesPanel, gridBagConstraints);
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_properties.border.title")));
        this.propertiesPanel.setLayout(new BorderLayout());
        this.propertiesScrollPane.setPreferredSize(new Dimension(150, 100));
        this.propertiesTable.setFont(this.propertiesTable.getFont());
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        this.propertiesPanel.add((Component)this.propertiesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.propertiesPanel, gridBagConstraints);
        this.historyPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_history.border.title")));
        this.historyPanel.setLayout(new BorderLayout());
        this.historyScrollPane.setPreferredSize(new Dimension(150, 100));
        this.historyTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.historyScrollPane.setViewportView(this.historyTable);
        this.historyPanel.add((Component)this.historyScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.historyPanel, gridBagConstraints);
        this.driveOrdersPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_driveOrders.border.title")));
        this.driveOrdersPanel.setLayout(new GridBagLayout());
        this.driveOrdersScrollPane.setPreferredSize(new Dimension(300, 100));
        this.driveOrdersScrollPane.setViewportView(this.driveOrdersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.driveOrdersPanel.add((Component)this.driveOrdersScrollPane, gridBagConstraints);
        this.driveOrdersPropertiesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_driveOrderProperties.border.title")));
        this.driveOrdersPropertiesPanel.setPreferredSize(new Dimension(162, 140));
        this.driveOrdersPropertiesPanel.setLayout(new BorderLayout());
        this.driveOrdersPropertiesScrollPane.setPreferredSize(new Dimension(150, 50));
        this.driveOrderPropertiesTable.setFont(this.driveOrderPropertiesTable.getFont());
        this.driveOrdersPropertiesScrollPane.setViewportView(this.driveOrderPropertiesTable);
        this.driveOrdersPropertiesPanel.add((Component)this.driveOrdersPropertiesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.driveOrdersPanel.add((Component)this.driveOrdersPropertiesPanel, gridBagConstraints);
        this.routePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("transportOrderView.panel_route.border.title")));
        this.routePanel.setPreferredSize(new Dimension(300, 140));
        this.routePanel.setLayout(new BorderLayout());
        this.routeScrollPane.setViewportView(this.routeTable);
        this.routePanel.add((Component)this.routeScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.driveOrdersPanel.add((Component)this.routePanel, gridBagConstraints);
        this.costsLabel.setFont(this.costsLabel.getFont());
        this.costsLabel.setText(bundle.getString("transportOrderView.label_costs.title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.driveOrdersPanel.add((Component)this.costsLabel, gridBagConstraints);
        this.costsTextField.setEditable(false);
        this.costsTextField.setColumns(5);
        this.costsTextField.setFont(this.costsTextField.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.driveOrdersPanel.add((Component)this.costsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add(this.driveOrdersPanel, gridBagConstraints);
    }

    private static class ToolTipCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JComponent)component).setToolTipText(value.toString());
            return component;
        }
    }
}

