/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport.orders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.StandardContentDialog;
import org.opentcs.guing.exchange.TransportOrderUtil;
import org.opentcs.guing.transport.CreateTransportOrderPanel;
import org.opentcs.guing.transport.FilterButton;
import org.opentcs.guing.transport.FilteredRowSorter;
import org.opentcs.guing.transport.OrdersTable;
import org.opentcs.guing.transport.orders.TransportOrderTableModel;
import org.opentcs.guing.transport.orders.TransportOrderView;
import org.opentcs.guing.transport.orders.TransportOrdersContainer;
import org.opentcs.guing.transport.orders.TransportViewFactory;
import org.opentcs.guing.util.IconToolkit;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOrdersContainerPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(TransportOrdersContainerPanel.class);
    private static final String ICON_PATH = "/org/opentcs/guing/res/symbols/panel/";
    private final SharedKernelServicePortalProvider portalProvider;
    private final TransportOrderUtil orderUtil;
    private final Provider<CreateTransportOrderPanel> orderPanelProvider;
    private final TransportViewFactory transportViewFactory;
    private JTable fTable;
    private TransportOrderTableModel tableModel;
    private FilteredRowSorter<TransportOrderTableModel> sorter;
    private final TransportOrdersContainer transportOrdersContainer;

    @Inject
    public TransportOrdersContainerPanel(SharedKernelServicePortalProvider portalProvider, TransportOrderUtil orderUtil, Provider<CreateTransportOrderPanel> orderPanelProvider, TransportViewFactory transportViewFactory, TransportOrdersContainer transportOrderContainer) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.orderPanelProvider = Objects.requireNonNull(orderPanelProvider, "orderPanelProvider");
        this.transportViewFactory = Objects.requireNonNull(transportViewFactory, "transportViewFactory");
        this.transportOrdersContainer = Objects.requireNonNull(transportOrderContainer, "transportOrderContainer");
        this.initComponents();
    }

    public void initView() {
        this.tableModel.containerInitialized(this.transportOrdersContainer.getTransportOrders());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new TransportOrderTableModel();
        this.transportOrdersContainer.addListener(this.tableModel);
        this.fTable = new OrdersTable(this.tableModel);
        this.fTable.setSelectionMode(2);
        this.sorter = new FilteredRowSorter<TransportOrderTableModel>(this.tableModel);
        this.sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(7, SortOrder.DESCENDING)));
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            this.sorter.setSortable(i, false);
        }
        this.sorter.setSortsOnUpdates(true);
        this.fTable.setRowSorter(this.sorter);
        this.fTable.removeColumn(this.fTable.getColumnModel().getColumn(this.fTable.convertColumnIndexToView(7)));
        JScrollPane scrollPane = new JScrollPane(this.fTable);
        this.add((Component)scrollPane, "Center");
        JToolBar toolBar = this.createToolBar(this.createFilterButtons());
        this.addControlButtons(toolBar);
        this.add((Component)toolBar, "North");
        this.fTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    TransportOrdersContainerPanel.this.showSelectedTransportOrder();
                }
                if (evt.getButton() == 3 && TransportOrdersContainerPanel.this.fTable.getSelectedRow() != -1) {
                    TransportOrdersContainerPanel.this.showPopupMenuForSelectedTransportOrder(evt.getX(), evt.getY());
                }
            }
        });
    }

    private void showSelectedTransportOrder() {
        this.getSelectedTransportOrder().ifPresent(transportOrder -> {
            TransportOrderView content = this.transportViewFactory.createTransportOrderView((TransportOrder)transportOrder);
            StandardContentDialog dialog = new StandardContentDialog((Component)JOptionPane.getFrameForComponent(this), (DialogContent)content, true, 12);
            dialog.setTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail").getString("transportOrdersContainerPanel.dialog_createTransportOrder.title"));
            dialog.setVisible(true);
        });
    }

    private void createTransportOrderWithPattern() {
        this.getSelectedTransportOrder().ifPresent(transportOrder -> {
            CreateTransportOrderPanel content = (CreateTransportOrderPanel)((Object)((Object)this.orderPanelProvider.get()));
            content.setPattern((TransportOrder)transportOrder);
            StandardContentDialog dialog = new StandardContentDialog((Component)JOptionPane.getFrameForComponent(this), (DialogContent)content);
            dialog.setVisible(true);
            if (dialog.getReturnStatus() == 1) {
                this.orderUtil.createTransportOrder(content.getDestinationModels(), content.getActions(), content.getPropertiesList(), content.getSelectedDeadline(), content.getSelectedVehicle(), content.getSelectedType());
            }
        });
    }

    private void createCopyOfSelectedTransportOrder() {
        this.getSelectedTransportOrder().ifPresent(transportOrder -> this.orderUtil.createTransportOrder((TransportOrder)transportOrder));
    }

    private void showPopupMenuForSelectedTransportOrder(int x, int y) {
        boolean singleRowSelected = this.fTable.getSelectedRowCount() <= 1;
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.transportOrders");
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(bundle.getString("transportOrdersContainerPanel.table_orders.popupMenuItem_showDetails.text"));
        item.setEnabled(singleRowSelected);
        item.addActionListener(evt -> this.showSelectedTransportOrder());
        menu.add(new JSeparator());
        item = menu.add(bundle.getString("transportOrdersContainerPanel.table_orders.popupMenuItem_orderAsTemplate.text"));
        item.setEnabled(singleRowSelected);
        item.addActionListener(evt -> this.createTransportOrderWithPattern());
        item = menu.add(bundle.getString("transportOrdersContainerPanel.table_orders.popupMenuItem_copyOrder.text"));
        item.setEnabled(singleRowSelected);
        item.addActionListener(evt -> this.createCopyOfSelectedTransportOrder());
        menu.show(this.fTable, x, y);
    }

    private void addControlButtons(JToolBar toolBar) {
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.transportOrders");
        toolBar.add(new JToolBar.Separator());
        JButton button = new JButton(IconToolkit.instance().getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/table-row-delete-2.16x16.png"));
        button.addActionListener(e -> this.withdrawTransportOrder());
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_withdrawSelectedOrders.tooltipText"));
        toolBar.add(button);
    }

    private Optional<TransportOrder> getSelectedTransportOrder() {
        int row = this.fTable.convertRowIndexToModel(this.fTable.getSelectedRow());
        if (row == -1) {
            return Optional.empty();
        }
        return Optional.of(this.tableModel.getEntryAt(row));
    }

    private List<JToggleButton> createFilterButtons() {
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.transportOrders");
        ArrayList<JToggleButton> buttons = new ArrayList<JToggleButton>();
        IconToolkit iconkit = IconToolkit.instance();
        FilterButton button = new FilterButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterRaw.16x16.gif"), this.createFilterForState(TransportOrder.State.RAW), this.sorter);
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_filterRawOrders.tooltipText"));
        buttons.add(button);
        button = new FilterButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterActivated.16x16.gif"), this.createFilterForState(TransportOrder.State.DISPATCHABLE), this.sorter);
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_filterDispatchableOrders.tooltipText"));
        buttons.add(button);
        button = new FilterButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterProcessing.16x16.gif"), this.createFilterForState(TransportOrder.State.BEING_PROCESSED), this.sorter);
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_filterProcessedOrders.tooltipText"));
        buttons.add(button);
        button = new FilterButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterFinished.16x16.gif"), this.createFilterForState(TransportOrder.State.FINISHED), this.sorter);
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_filterFinishedOrders.tooltipText"));
        buttons.add(button);
        button = new FilterButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterFailed.16x16.gif"), this.createFilterForState(TransportOrder.State.FAILED), this.sorter);
        button.setToolTipText(bundle.getString("transportOrdersContainerPanel.button_filterFailedOrders.tooltipText"));
        buttons.add(button);
        return buttons;
    }

    private RowFilter<Object, Object> createFilterForState(final TransportOrder.State state) {
        return new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                TransportOrder order = ((TransportOrderTableModel)entry.getModel()).getEntryAt((Integer)entry.getIdentifier());
                return order.getState() != state;
            }
        };
    }

    private JToolBar createToolBar(List<JToggleButton> filterButtons) {
        JToolBar toolBar = new JToolBar();
        for (JToggleButton button : filterButtons) {
            toolBar.add(button);
        }
        return toolBar;
    }

    private void withdrawTransportOrder() {
        int[] indices = this.fTable.getSelectedRows();
        ArrayList<TransportOrder> toWithdraw = new ArrayList<TransportOrder>();
        for (int i = 0; i < indices.length; ++i) {
            int modelIndex = this.fTable.convertRowIndexToModel(indices[i]);
            TransportOrder order = this.tableModel.getEntryAt(modelIndex);
            toWithdraw.add(order);
        }
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            for (TransportOrder order : toWithdraw) {
                sharedPortal.getPortal().getDispatcherService().withdrawByTransportOrder(order.getReference(), false);
            }
        }
        catch (KernelRuntimeException exc) {
            LOG.warn("Exception withdrawing transport order", (Throwable)exc);
        }
    }
}

