/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.transport.sequences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.guing.event.KernelStateChangeEvent;
import org.opentcs.guing.event.OperationModeChangeEvent;
import org.opentcs.guing.event.SystemModelTransitionEvent;
import org.opentcs.guing.transport.sequences.OrderSequenceContainerListener;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSequencesContainer
implements Lifecycle,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OrderSequencesContainer.class);
    private final EventBus eventBus;
    private final SharedKernelServicePortalProvider portalProvider;
    private final Map<String, OrderSequence> orderSequences = new HashMap<String, OrderSequence>();
    private final Set<OrderSequenceContainerListener> listeners = new HashSet<OrderSequenceContainerListener>();
    private boolean initialized;

    @Inject
    public OrderSequencesContainer(@ApplicationEventBus EventBus eventBus, SharedKernelServicePortalProvider portalProvider) {
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof TCSObjectEvent) {
            this.handleObjectEvent((TCSObjectEvent)event);
        } else if (event instanceof OperationModeChangeEvent) {
            this.initSequences();
        } else if (event instanceof SystemModelTransitionEvent) {
            this.initSequences();
        } else if (event instanceof KernelStateChangeEvent) {
            this.initSequences();
        }
    }

    private void initSequences() {
        this.setOrderSequences(this.fetchSequencesIfOnline());
        this.listeners.forEach(listener -> listener.containerInitialized(this.orderSequences.values()));
    }

    private Set<OrderSequence> fetchSequencesIfOnline() {
        if (this.portalProvider.portalShared()) {
            Set set;
            block9: {
                SharedKernelServicePortal sharedPortal = this.portalProvider.register();
                try {
                    set = sharedPortal.getPortal().getTransportOrderService().fetchObjects(OrderSequence.class);
                    if (sharedPortal == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (sharedPortal != null) {
                            try {
                                sharedPortal.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (KernelRuntimeException exc) {
                        LOG.warn("Exception fetching order sequences", (Throwable)exc);
                    }
                }
                sharedPortal.close();
            }
            return set;
        }
        return new HashSet<OrderSequence>();
    }

    public void addListener(OrderSequenceContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OrderSequenceContainerListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<OrderSequence> getOrderSequences() {
        return this.orderSequences.values();
    }

    private void handleObjectEvent(TCSObjectEvent evt) {
        if (evt.getCurrentOrPreviousObjectState() instanceof OrderSequence) {
            switch (evt.getType()) {
                case OBJECT_CREATED: {
                    this.orderSequenceAdded((OrderSequence)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                case OBJECT_MODIFIED: {
                    this.orderSequencesChanged((OrderSequence)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                case OBJECT_REMOVED: {
                    this.orderSequenceRemoved((OrderSequence)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                default: {
                    LOG.warn("Unhandled event type: {}", (Object)evt.getType());
                }
            }
        }
    }

    private void orderSequenceAdded(OrderSequence seq) {
        this.orderSequences.put(seq.getName(), seq);
        this.listeners.forEach(listener -> listener.orderSequenceAdded(seq));
    }

    private void orderSequencesChanged(OrderSequence seq) {
        this.orderSequences.put(seq.getName(), seq);
        this.listeners.forEach(listener -> listener.orderSequenceUpdated(seq));
    }

    private void orderSequenceRemoved(OrderSequence seq) {
        this.orderSequences.remove(seq.getName());
        this.listeners.forEach(listener -> listener.orderSequenceRemoved(seq));
    }

    private void setOrderSequences(Set<OrderSequence> sequences) {
        this.orderSequences.clear();
        for (OrderSequence seq : sequences) {
            this.orderSequences.put(seq.getName(), seq);
        }
    }
}

