/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.opentcs.configuration.ConfigurationBindingProvider;
import org.opentcs.configuration.cfg4j.Cfg4jConfigurationBindingProvider;
import org.opentcs.customizations.plantoverview.PlantOverviewInjectionModule;
import org.opentcs.guing.common.util.CompatibilityChecker;
import org.opentcs.operationsdesk.DefaultPlantOverviewInjectionModule;
import org.opentcs.operationsdesk.application.PlantOverviewStarter;
import org.opentcs.util.Environment;
import org.opentcs.util.logging.UncaughtExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunOperationsDesk {
    private static final Logger LOG = LoggerFactory.getLogger(RunOperationsDesk.class);

    private RunOperationsDesk() {
    }

    public static void main(String[] args) {
        System.setSecurityManager(new SecurityManager());
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(false));
        Environment.logSystemInfo();
        RunOperationsDesk.ensureVersionCompatibility();
        Injector injector = Guice.createInjector((Module[])new Module[]{RunOperationsDesk.customConfigurationModule()});
        ((PlantOverviewStarter)injector.getInstance(PlantOverviewStarter.class)).startPlantOverview();
    }

    private static void ensureVersionCompatibility() {
        String version = System.getProperty("java.version");
        if (!CompatibilityChecker.versionCompatibleWithDockingFrames((String)version)) {
            LOG.error("Version incompatible with Docking Frames: '{}'", (Object)version);
            CompatibilityChecker.showVersionIncompatibleWithDockingFramesMessage();
            System.exit(1);
        }
    }

    private static Module customConfigurationModule() {
        ConfigurationBindingProvider bindingProvider = RunOperationsDesk.configurationBindingProvider();
        DefaultPlantOverviewInjectionModule plantOverviewInjectionModule = new DefaultPlantOverviewInjectionModule();
        plantOverviewInjectionModule.setConfigBindingProvider(bindingProvider);
        return Modules.override((Module[])new Module[]{plantOverviewInjectionModule}).with(RunOperationsDesk.findRegisteredModules(bindingProvider));
    }

    private static List<PlantOverviewInjectionModule> findRegisteredModules(ConfigurationBindingProvider bindingProvider) {
        ArrayList<PlantOverviewInjectionModule> registeredModules = new ArrayList<PlantOverviewInjectionModule>();
        for (PlantOverviewInjectionModule module : ServiceLoader.load(PlantOverviewInjectionModule.class)) {
            LOG.info("Integrating injection module {} (source: {})", (Object)module.getClass().getName(), (Object)module.getClass().getProtectionDomain().getCodeSource());
            module.setConfigBindingProvider(bindingProvider);
            registeredModules.add(module);
        }
        return registeredModules;
    }

    private static ConfigurationBindingProvider configurationBindingProvider() {
        return new Cfg4jConfigurationBindingProvider(Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-operationsdesk-defaults-baseline.properties").toAbsolutePath(), new Path[]{Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-operationsdesk-defaults-custom.properties").toAbsolutePath(), Paths.get(System.getProperty("opentcs.home", "."), "config", "opentcs-operationsdesk.properties").toAbsolutePath()});
    }
}

