/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application;

import java.awt.Dimension;
import java.awt.Font;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.guing.common.util.MessageDisplay;

public class KernelStatusPanel
extends JScrollPane
implements MessageDisplay {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    private final JTextArea statusTextArea = new JTextArea();

    public KernelStatusPanel() {
        this.initComponents();
    }

    public void display(UserNotification notification) {
        Objects.requireNonNull(notification, "message");
        this.statusTextArea.append(DATE_FORMAT.format(notification.getTimestamp()) + " " + notification.getLevel() + ": [" + notification.getSource() + "] " + notification.getText() + "\n");
        this.statusTextArea.setCaretPosition(this.statusTextArea.getDocument().getLength());
    }

    private void initComponents() {
        DefaultCaret caret = (DefaultCaret)this.statusTextArea.getCaret();
        caret.setUpdatePolicy(2);
        this.setVerticalScrollBarPolicy(22);
        this.setAutoscrolls(true);
        this.setPreferredSize(new Dimension(183, 115));
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setColumns(20);
        this.statusTextArea.setFont(new Font("Monospaced", 0, 11));
        this.statusTextArea.setLineWrap(true);
        this.statusTextArea.setRows(5);
        this.statusTextArea.setWrapStyleWord(true);
        this.setViewportView(this.statusTextArea);
    }
}

