/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.util.ReversedList;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.components.plantoverview.PlantModelExporter;
import org.opentcs.components.plantoverview.PlantModelImporter;
import org.opentcs.components.plantoverview.PluggablePanel;
import org.opentcs.components.plantoverview.PluggablePanelFactory;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.guing.base.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.components.properties.type.AbstractProperty;
import org.opentcs.guing.base.components.properties.type.LengthProperty;
import org.opentcs.guing.base.event.BlockChangeEvent;
import org.opentcs.guing.base.event.BlockChangeListener;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.PropertiesCollection;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.base.model.elements.LayoutModel;
import org.opentcs.guing.base.model.elements.LinkModel;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.LocationTypeModel;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.application.ApplicationState;
import org.opentcs.guing.common.application.ComponentsManager;
import org.opentcs.guing.common.application.GuiManager;
import org.opentcs.guing.common.application.ModelRestorationProgressStatus;
import org.opentcs.guing.common.application.OperationMode;
import org.opentcs.guing.common.application.PluginPanelManager;
import org.opentcs.guing.common.application.ProgressIndicator;
import org.opentcs.guing.common.application.ProgressStatus;
import org.opentcs.guing.common.application.StartupProgressStatus;
import org.opentcs.guing.common.application.StatusPanel;
import org.opentcs.guing.common.components.dockable.CStackDockStation;
import org.opentcs.guing.common.components.dockable.DockableHandlerFactory;
import org.opentcs.guing.common.components.dockable.DrawingViewFocusHandler;
import org.opentcs.guing.common.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.common.components.drawing.course.Origin;
import org.opentcs.guing.common.components.drawing.course.OriginChangeListener;
import org.opentcs.guing.common.components.drawing.figures.FigureConstants;
import org.opentcs.guing.common.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.common.components.drawing.figures.LabeledPointFigure;
import org.opentcs.guing.common.components.layer.LayerManager;
import org.opentcs.guing.common.components.properties.AttributesContent;
import org.opentcs.guing.common.components.properties.SelectionPropertiesComponent;
import org.opentcs.guing.common.components.properties.panel.PropertiesPanelFactory;
import org.opentcs.guing.common.components.tree.BlocksTreeViewManager;
import org.opentcs.guing.common.components.tree.ComponentsTreeViewManager;
import org.opentcs.guing.common.components.tree.TreeViewManager;
import org.opentcs.guing.common.components.tree.elements.UserObject;
import org.opentcs.guing.common.components.tree.elements.VehicleUserObject;
import org.opentcs.guing.common.event.DrawingEditorEvent;
import org.opentcs.guing.common.event.DrawingEditorListener;
import org.opentcs.guing.common.event.ModelNameChangeEvent;
import org.opentcs.guing.common.event.OperationModeChangeEvent;
import org.opentcs.guing.common.event.ResetInteractionToolCommand;
import org.opentcs.guing.common.event.SystemModelTransitionEvent;
import org.opentcs.guing.common.model.SystemModel;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.PanelRegistry;
import org.opentcs.guing.common.util.UserMessageHelper;
import org.opentcs.operationsdesk.application.KernelStatusPanel;
import org.opentcs.operationsdesk.application.ViewManagerOperating;
import org.opentcs.operationsdesk.application.action.ToolBarManager;
import org.opentcs.operationsdesk.application.action.ViewActionMap;
import org.opentcs.operationsdesk.components.dialogs.VehiclesPanel;
import org.opentcs.operationsdesk.components.dockable.DockingManagerOperating;
import org.opentcs.operationsdesk.components.drawing.DrawingViewFactory;
import org.opentcs.operationsdesk.components.drawing.OpenTCSDrawingEditorOperating;
import org.opentcs.operationsdesk.event.KernelStateChangeEvent;
import org.opentcs.operationsdesk.exchange.TransportOrderUtil;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobsContainerPanel;
import org.opentcs.operationsdesk.transport.orders.TransportOrdersContainerPanel;
import org.opentcs.operationsdesk.transport.sequences.OrderSequencesContainerPanel;
import org.opentcs.operationsdesk.util.Cursors;
import org.opentcs.operationsdesk.util.PlantOverviewOperatingApplicationConfiguration;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.edit.UndoRedoManager;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.toolbar.PaletteToolBarBorder;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.thirdparty.operationsdesk.jhotdraw.application.action.file.CloseFileAction;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCSView
extends AbstractView
implements GuiManager,
ComponentsManager,
PluginPanelManager,
EventHandler {
    public static final String NAME = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.miscellaneous").getString("openTcsView.applicationName.text");
    public static final String MODELNAME_PROPERTY = "modelName";
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCSView.class);
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.miscellaneous");
    private final ApplicationState appState;
    private final UndoRedoManager fUndoRedoManager;
    private final OpenTCSDrawingEditorOperating fDrawingEditor;
    private final JFrame fFrame;
    private final ViewManagerOperating viewManager;
    private final TreeViewManager fComponentsTreeManager;
    private final TreeViewManager fBlocksTreeManager;
    private final SelectionPropertiesComponent fPropertiesComponent;
    private final ModelManager fModelManager;
    private final ProgressIndicator progressIndicator;
    private final DockingManagerOperating dockingManager;
    private final PanelRegistry panelRegistry;
    private final SharedKernelServicePortalProvider portalProvider;
    private SharedKernelServicePortal sharedPortal;
    private final KernelStatusPanel kernelStatusPanel;
    private final StatusPanel statusPanel;
    private final VehiclesPanel vehiclesPanel;
    private final UserMessageHelper userMessageHelper;
    private final DrawingViewFactory drawingViewFactory;
    private final BlockChangeListener blockEventHandler = new BlockEventHandler();
    private final AttributesChangeListener attributesEventHandler = new AttributesEventHandler();
    private final Provider<ViewActionMap> actionMapProvider;
    private final Provider<ToolBarManager> toolBarManagerProvider;
    private final PropertiesPanelFactory propertiesPanelFactory;
    private final Provider<TransportOrdersContainerPanel> toContainerPanelProvider;
    private final Provider<OrderSequencesContainerPanel> osContainerPanelProvider;
    private final Provider<PeripheralJobsContainerPanel> pjContainerPanelProvider;
    private final TransportOrderUtil orderUtil;
    private final EventBus eventBus;
    private final DrawingViewFocusHandler drawingViewFocusHandler;
    private final DockableHandlerFactory dockableHandlerFactory;
    private final LayerManager layerManager;
    private final PlantOverviewOperatingApplicationConfiguration configuration;
    private ToolBarManager toolBarManager;

    @Inject
    public OpenTCSView(ApplicationState appState, @ApplicationFrame JFrame appFrame, ProgressIndicator progressIndicator, SharedKernelServicePortalProvider portalProvider, ViewManagerOperating viewManager, OpenTCSDrawingEditorOperating tcsDrawingEditor, ModelManager modelManager, StatusPanel statusPanel, PanelRegistry panelRegistry, UserMessageHelper userMessageHelper, DrawingViewFactory drawingViewFactory, UndoRedoManager undoRedoManager, ComponentsTreeViewManager componentsTreeManager, BlocksTreeViewManager blocksTreeManager, KernelStatusPanel kernelStatusPanel, SelectionPropertiesComponent propertiesComponent, VehiclesPanel vehiclesPanel, Provider<ViewActionMap> actionMapProvider, Provider<ToolBarManager> toolBarManagerProvider, PropertiesPanelFactory propertiesPanelFactory, Provider<TransportOrdersContainerPanel> toContainerPanelProvider, Provider<OrderSequencesContainerPanel> osContainerPanelProvider, Provider<PeripheralJobsContainerPanel> pjContainerPanelProvider, TransportOrderUtil orderUtil, @ApplicationEventBus EventBus eventBus, DockingManagerOperating dockingManager, DrawingViewFocusHandler drawingViewFocusHandler, DockableHandlerFactory dockableHandlerFactory, LayerManager layerManager, PlantOverviewOperatingApplicationConfiguration configuration) {
        this.appState = Objects.requireNonNull(appState, "appState");
        this.fFrame = Objects.requireNonNull(appFrame, "appFrame");
        this.progressIndicator = Objects.requireNonNull(progressIndicator, "progressIndicator");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.viewManager = Objects.requireNonNull(viewManager, "viewManager");
        this.fDrawingEditor = Objects.requireNonNull(tcsDrawingEditor, "tcsDrawingEditor");
        this.fModelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
        this.panelRegistry = Objects.requireNonNull(panelRegistry, "panelRegistry");
        this.userMessageHelper = Objects.requireNonNull(userMessageHelper, "userMessageHelper");
        this.drawingViewFactory = Objects.requireNonNull(drawingViewFactory, "drawingViewFactory");
        this.fUndoRedoManager = Objects.requireNonNull(undoRedoManager, "undoRedoManager");
        this.fComponentsTreeManager = (TreeViewManager)Objects.requireNonNull(componentsTreeManager, "componentsTreeManager");
        this.fBlocksTreeManager = (TreeViewManager)Objects.requireNonNull(blocksTreeManager, "blocksTreeManager");
        this.kernelStatusPanel = Objects.requireNonNull(kernelStatusPanel, "kernelStatusPanel");
        this.fPropertiesComponent = Objects.requireNonNull(propertiesComponent, "propertiesComponent");
        this.vehiclesPanel = Objects.requireNonNull(vehiclesPanel, "vehiclesPanel");
        this.actionMapProvider = Objects.requireNonNull(actionMapProvider, "actionMapProvider");
        this.toolBarManagerProvider = Objects.requireNonNull(toolBarManagerProvider, "toolBarManagerProvider");
        this.propertiesPanelFactory = Objects.requireNonNull(propertiesPanelFactory, "propertiesPanelFactory");
        this.toContainerPanelProvider = Objects.requireNonNull(toContainerPanelProvider, "toContainerPanelProvider");
        this.osContainerPanelProvider = Objects.requireNonNull(osContainerPanelProvider, "osContainerPanelProvider");
        this.pjContainerPanelProvider = Objects.requireNonNull(pjContainerPanelProvider, "pjContainerPanelProvider");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.dockingManager = Objects.requireNonNull(dockingManager, "dockingManager");
        this.drawingViewFocusHandler = Objects.requireNonNull(drawingViewFocusHandler, "drawingViewFocusHandler");
        this.dockableHandlerFactory = Objects.requireNonNull(dockableHandlerFactory, "dockableHandlerFactory");
        this.layerManager = Objects.requireNonNull(layerManager, "layerManager");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public void init() {
        this.eventBus.subscribe((EventHandler)this);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.INITIALIZED);
        this.fDrawingEditor.addDrawingEditorListener(new DrawingEditorEventHandler(this.fModelManager));
        this.eventBus.subscribe((EventHandler)this.fComponentsTreeManager);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.INITIALIZE_MODEL);
        this.setSystemModel(this.fModelManager.getModel());
        this.fPropertiesComponent.setPropertiesContent((AttributesContent)this.propertiesPanelFactory.createPropertiesTableContent((JPanel)((Object)this)));
        VehicleDragHandler listener = new VehicleDragHandler(Cursors.getDragVehicleCursor());
        this.fComponentsTreeManager.addMouseListener((MouseListener)listener);
        this.fComponentsTreeManager.addMouseMotionListener((MouseMotionListener)listener);
        this.setActionMap((ActionMap)this.actionMapProvider.get());
        this.toolBarManager = (ToolBarManager)this.toolBarManagerProvider.get();
        this.eventBus.subscribe((EventHandler)this.toolBarManager);
        this.eventBus.subscribe((EventHandler)this.fPropertiesComponent);
        this.eventBus.subscribe((EventHandler)this.vehiclesPanel);
        this.eventBus.subscribe((EventHandler)this.fUndoRedoManager);
        this.eventBus.subscribe((EventHandler)this.fDrawingEditor);
        this.layerManager.initialize();
        this.initializeFrame();
        this.viewManager.init();
        this.createEmptyModel();
        this.switchToOperatingState();
    }

    public void stop() {
        LOG.info("GUI terminating...");
        this.eventBus.unsubscribe((EventHandler)this);
        System.exit(0);
    }

    public void clear() {
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            this.handleSystemModelTransition((SystemModelTransitionEvent)event);
        }
        if (event instanceof KernelStateChangeEvent) {
            this.handleKernelStateChangeEvent((KernelStateChangeEvent)event);
        }
    }

    private void handleSystemModelTransition(SystemModelTransitionEvent evt) {
        switch (evt.getStage()) {
            case LOADED: {
                this.setHasUnsavedChanges(false);
                this.setModelNameProperty(this.fModelManager.getModel().getName());
                break;
            }
        }
    }

    public void showPluginPanel(PluggablePanelFactory factory, boolean visible) {
        PluggablePanel panel;
        String id = factory.getClass().getName();
        SingleCDockable dockable = this.dockingManager.getCControl().getSingleDockable(id);
        if (dockable != null) {
            panel = (PluggablePanel)dockable.getFocusComponent();
            panel.terminate();
            if (!this.dockingManager.getCControl().removeDockable(dockable)) {
                LOG.warn("Couldn't remove dockable for plugin panel factory '{}'", (Object)factory);
                return;
            }
        }
        if (!visible) {
            return;
        }
        if (factory.providesPanel(OperationMode.equivalent((OperationMode)this.appState.getOperationMode()))) {
            panel = factory.createPanel(OperationMode.equivalent((OperationMode)this.appState.getOperationMode()));
            final DefaultSingleCDockable factoryDockable = this.dockingManager.createFloatingDockable(factory.getClass().getName(), factory.getPanelDescription(), (JComponent)panel);
            factoryDockable.addVetoClosingListener(new CVetoClosingListener(){

                public void closing(CVetoClosingEvent event) {
                }

                public void closed(CVetoClosingEvent event) {
                    panel.terminate();
                    OpenTCSView.this.dockingManager.getCControl().removeDockable((SingleCDockable)factoryDockable);
                }
            });
            panel.initialize();
        }
    }

    public DefaultSingleCDockable addDrawingView() {
        DrawingViewScrollPane newScrollPane = this.drawingViewFactory.createDrawingView(this.fModelManager.getModel(), this.toolBarManager.getSelectionToolButton(), this.toolBarManager.getDragToolButton());
        int drawingViewIndex = this.viewManager.getNextDrawingViewIndex();
        String title = this.bundle.getString("openTcsView.panel_operatingDrawingView.title") + " " + drawingViewIndex;
        DefaultSingleCDockable newDockable = this.dockingManager.createDockable("drivingCourse" + drawingViewIndex, title, (JComponent)newScrollPane, true);
        this.viewManager.addDrawingView(newDockable, newScrollPane);
        int lastIndex = Math.max(0, drawingViewIndex - 1);
        this.dockingManager.addTabTo(newDockable, "course_tab_pane", lastIndex);
        newDockable.addVetoClosingListener((CVetoClosingListener)new DrawingViewClosingListener(newDockable));
        newDockable.addFocusListener((CFocusListener)this.drawingViewFocusHandler);
        newScrollPane.getDrawingView().getComponent().dispatchEvent(new FocusEvent((Component)((Object)this), 1004));
        this.firePropertyChange("focusGained", null, newDockable);
        return newDockable;
    }

    public void addTransportOrderView() {
        int biggestIndex = this.viewManager.getNextTransportOrderViewIndex();
        DefaultSingleCDockable lastTOView = this.viewManager.getLastTransportOrderView();
        TransportOrdersContainerPanel panel = (TransportOrdersContainerPanel)this.toContainerPanelProvider.get();
        DefaultSingleCDockable newDockable = this.dockingManager.createDockable("transportOrders" + biggestIndex, this.bundle.getString("openTcsView.panel_operatingTransportOrdersView.title") + " " + biggestIndex, panel, true);
        this.viewManager.addTransportOrderView(newDockable, panel);
        panel.initView();
        newDockable.addVetoClosingListener((CVetoClosingListener)this.dockableHandlerFactory.createDockableClosingHandler(newDockable));
        int indexToInsert = lastTOView != null ? ((CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation()).indexOf((Dockable)lastTOView.intern()) + 1 : this.viewManager.getDrawingViewMap().size();
        this.dockingManager.addTabTo(newDockable, "course_tab_pane", indexToInsert);
    }

    public void addTransportOrderSequenceView() {
        int biggestIndex = this.viewManager.getNextOrderSequenceViewIndex();
        DefaultSingleCDockable lastOSView = this.viewManager.getLastOrderSequenceView();
        OrderSequencesContainerPanel panel = (OrderSequencesContainerPanel)this.osContainerPanelProvider.get();
        DefaultSingleCDockable newDockable = this.dockingManager.createDockable("orderSequences" + biggestIndex, this.bundle.getString("openTcsView.panel_operatingOrderSequencesView.title") + " " + biggestIndex, panel, true);
        this.viewManager.addOrderSequenceView(newDockable, panel);
        panel.initView();
        newDockable.addVetoClosingListener((CVetoClosingListener)this.dockableHandlerFactory.createDockableClosingHandler(newDockable));
        int indexToInsert = lastOSView != null ? ((CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation()).indexOf((Dockable)lastOSView.intern()) + 1 : this.viewManager.getTransportOrderMap().size() + this.viewManager.getDrawingViewMap().size();
        this.dockingManager.addTabTo(newDockable, "course_tab_pane", indexToInsert);
    }

    public void addPeripheralJobsView() {
        int biggestIndex = this.viewManager.getNextPeripheralJobViewIndex();
        DefaultSingleCDockable lastView = this.viewManager.getLastPeripheralJobView();
        PeripheralJobsContainerPanel panel = (PeripheralJobsContainerPanel)this.pjContainerPanelProvider.get();
        DefaultSingleCDockable newDockable = this.dockingManager.createDockable("peripheralJobs" + biggestIndex, this.bundle.getString("openTcsView.panel_peripheralJobsView.title") + " " + biggestIndex, panel, true);
        this.viewManager.addPeripheralJobView(newDockable, panel);
        panel.initView();
        newDockable.addVetoClosingListener((CVetoClosingListener)this.dockableHandlerFactory.createDockableClosingHandler(newDockable));
        int indexToInsert = lastView != null ? ((CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation()).indexOf((Dockable)lastView.intern()) + 1 : this.viewManager.getTransportOrderMap().size() + this.viewManager.getOrderSequenceMap().size() + this.viewManager.getDrawingViewMap().size();
        this.dockingManager.addTabTo(newDockable, "course_tab_pane", indexToInsert);
    }

    public void resetWindowArrangement() {
        for (DefaultSingleCDockable dock : new ArrayList(this.viewManager.getDrawingViewMap().keySet())) {
            this.removeDrawingView(dock);
        }
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.viewManager.getTransportOrderMap().keySet())) {
            this.dockingManager.removeDockable((SingleCDockable)dock);
        }
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.viewManager.getOrderSequenceMap().keySet())) {
            this.dockingManager.removeDockable((SingleCDockable)dock);
        }
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.viewManager.getPeripheralJobMap().keySet())) {
            this.dockingManager.removeDockable((SingleCDockable)dock);
        }
        this.dockingManager.reset();
        this.closeOpenedPluginPanels();
        this.viewManager.reset();
        this.initializeFrame();
        this.viewManager.init();
        new Thread(() -> this.setOperatingState()).start();
    }

    private void log(UserNotification message) {
        this.kernelStatusPanel.display(message);
    }

    public void createEmptyModel() {
        CloseFileAction action = (CloseFileAction)this.getActionMap().get("file.close");
        if (action != null) {
            action.actionPerformed(new ActionEvent((Object)this, 1001, "modelClosing"));
            if (action.getFileSavedStatus() == 2) {
                return;
            }
        }
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADING, this.fModelManager.getModel()));
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADED, this.fModelManager.getModel()));
        LOG.debug("Creating new driving course model...");
        this.fModelManager.createEmptyModel();
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADING, this.fModelManager.getModel()));
        this.setSystemModel(this.fModelManager.getModel());
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADED, this.fModelManager.getModel()));
        this.fDrawingEditor.initializeViewport();
    }

    public void loadCurrentKernelModel() {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            this.loadCurrentKernelModel(sharedPortal.getPortal());
        }
        catch (ServiceUnavailableException exc) {
            LOG.info("Kernel unavailable, aborting.", (Throwable)exc);
        }
    }

    private void loadCurrentKernelModel(KernelServicePortal portal) {
        if (this.hasUnsavedChanges() && !this.showUnsavedChangesDialog()) {
            return;
        }
        if (portal.getState() == Kernel.State.MODELLING) {
            this.handleKernelInModellingMode();
            return;
        }
        this.restoreModel(portal);
    }

    private void restoreModel(@Nullable KernelServicePortal portal) {
        this.progressIndicator.initialize();
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.CLEANUP);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADING, this.fModelManager.getModel()));
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.START_LOADING_MODEL);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADED, this.fModelManager.getModel()));
        if (portal == null) {
            this.fModelManager.restoreModel();
        } else {
            this.fModelManager.restoreModel(portal);
            this.statusPanel.setLogMessage(Level.INFO, this.bundle.getFormatted("openTcsView.message_modelLoaded.text", new Object[]{this.fModelManager.getModel().getName()}));
        }
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_MODEL_VIEW);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADING, this.fModelManager.getModel()));
        this.setSystemModel(this.fModelManager.getModel());
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_DIRECTORY_TREE);
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_WORKING_AREA);
        ModelComponent layoutComponent = this.fModelManager.getModel().getMainFolder(SystemModel.FolderKey.LAYOUT);
        layoutComponent.addAttributesChangeListener(this.attributesEventHandler);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADED, this.fModelManager.getModel()));
        this.updateModelName();
        this.progressIndicator.terminate();
    }

    private boolean showSwitchStateUnsavedChangesDialog() {
        String title = this.bundle.getString("openTcsView.dialog_unsavedChanges.title");
        String text = this.bundle.getString("openTcsView.dialog_unsavedChanges.message");
        String[] options = new String[]{this.bundle.getString("openTcsView.dialog_unsavedChanges.option_upload.text"), this.bundle.getString("openTcsView.dialog_unsavedChanges.option_discard.text"), this.bundle.getString("openTcsView.dialog_unsavedChanges.option_cancel.text")};
        switch (this.userMessageHelper.showOptionsDialog(title, text, UserMessageHelper.Type.ERROR, options)) {
            case 0: {
                return this.uploadModelToKernel();
            }
            case 1: {
                this.setHasUnsavedChanges(false);
                return true;
            }
        }
        return false;
    }

    private void handleKernelStateChangeEvent(KernelStateChangeEvent event) {
        this.closeOpenedPluginPanels();
        switch (event.getNewState()) {
            case MODELLING: {
                this.handleKernelInModellingMode();
                break;
            }
            case OPERATING: {
                if (this.hasUnsavedChanges() && !this.showSwitchStateUnsavedChangesDialog()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.loadCurrentKernelModel());
                break;
            }
            default: {
                this.handleNoKernelConnection();
            }
        }
    }

    private void handleNoKernelConnection() {
        if (this.sharedPortal != null) {
            this.sharedPortal.close();
            this.sharedPortal = null;
        }
        JOptionPane.showMessageDialog(this.fFrame, this.bundle.getFormatted("openTcsView.optionPane_kernelConnectionLost.message", new Object[0]), this.bundle.getFormatted("openTcsView.optionPane_kernelConnectionLost.title", new Object[0]), 0);
        System.exit(1);
    }

    private void switchToOperatingState() {
        try {
            this.sharedPortal = this.portalProvider.register();
            if (this.sharedPortal.getPortal().getState() != Kernel.State.OPERATING) {
                this.handleKernelInModellingMode();
            }
            this.setOperatingState();
            SwingUtilities.invokeLater(() -> this.loadCurrentKernelModel());
        }
        catch (ServiceUnavailableException exc) {
            this.handleNoKernelConnection();
        }
    }

    private void handleKernelInModellingMode() {
        this.createEmptyModel();
        String text = this.bundle.getFormatted("openTcsView.message_kernelInModelling.text", new Object[]{this.bundle.getString("openTcsView.state_modelling.text"), this.bundle.getString("openTcsView.state_operating.text")});
        this.log(new UserNotification(text, UserNotification.Level.INFORMATIONAL));
    }

    private void setModelNameProperty(String modelName) {
        this.fModelManager.getModel().setName(modelName);
        this.eventBus.onEvent((Object)new ModelNameChangeEvent((Object)this, modelName));
    }

    public void updateModelName() {
        String newName = this.fModelManager.getModel().getName();
        this.eventBus.onEvent((Object)new ModelNameChangeEvent((Object)this, newName));
    }

    public void addBackgroundBitmap(File file) {
        this.getActiveDrawingView().addBackgroundBitmap(file);
    }

    public List<UserObject> restoreModelComponents(List<UserObject> userObjects) {
        return new ArrayList<UserObject>();
    }

    public void write(URI f, URIChooser chooser) throws IOException {
    }

    public void read(URI f, URIChooser chooser) throws IOException {
    }

    public boolean canSaveTo(URI file) {
        return new File(file).getName().endsWith(".xml");
    }

    public URI getURI() {
        String modelName = this.fModelManager.getModel().getName();
        try {
            this.uri = new URI(modelName);
        }
        catch (URISyntaxException ex) {
            LOG.warn("URISyntaxException in getURI({})", (Object)modelName, (Object)ex);
        }
        return this.uri;
    }

    private List<OpenTCSDrawingView> getDrawingViews() {
        ArrayList<OpenTCSDrawingView> views = new ArrayList<OpenTCSDrawingView>();
        for (DrawingViewScrollPane scrollPane : this.viewManager.getDrawingViewMap().values()) {
            views.add(scrollPane.getDrawingView());
        }
        return views;
    }

    public void selectModelComponent(ModelComponent modelComponent) {
        this.fPropertiesComponent.setModel(modelComponent);
        OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
        drawingView.clearSelection();
        Figure figure = this.findFigure(modelComponent);
        if (figure != null) {
            drawingView.toggleSelection(figure);
        }
    }

    public void addSelectedModelComponent(ModelComponent modelComponent) {
        Set components = this.fComponentsTreeManager.getSelectedItems();
        if (components.size() > 1) {
            components.add(modelComponent);
            OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
            drawingView.clearSelection();
            LinkedList<Figure> figures = new LinkedList<Figure>();
            for (ModelComponent comp : components) {
                Figure figure = this.findFigure(comp);
                if (figure == null) continue;
                figures.add(figure);
            }
            drawingView.addToSelection(figures);
            this.fPropertiesComponent.setModel((ModelComponent)new PropertiesCollection((Collection)components));
            this.fComponentsTreeManager.selectItems(components);
        } else {
            this.selectModelComponent(modelComponent);
        }
    }

    public boolean treeComponentRemoved(ModelComponent model) {
        return false;
    }

    public void figureSelected(ModelComponent modelComponent) {
        modelComponent.addAttributesChangeListener(this.attributesEventHandler);
        this.fPropertiesComponent.setModel(modelComponent);
        Figure figure = this.findFigure(modelComponent);
        OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
        if (figure != null) {
            drawingView.clearSelection();
            drawingView.addToSelection(figure);
            drawingView.scrollTo(figure);
        }
    }

    public void loadModel() {
    }

    public void importModel(PlantModelImporter importer) {
    }

    private boolean showUnsavedChangesDialog() {
        CloseFileAction action = (CloseFileAction)this.getActionMap().get("file.close");
        action.actionPerformed(new ActionEvent((Object)this, 1001, "modelClosing"));
        switch (action.getFileSavedStatus()) {
            case 0: {
                super.setHasUnsavedChanges(false);
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private boolean uploadModelToKernel() {
        return false;
    }

    public boolean saveModel() {
        boolean saved = this.fModelManager.saveModelToFile(false);
        if (saved) {
            String modelName = this.fModelManager.getModel().getName();
            this.setModelNameProperty(modelName);
            this.setHasUnsavedChanges(false);
        }
        return saved;
    }

    public boolean saveModelAs() {
        boolean saved = this.fModelManager.saveModelToFile(true);
        if (saved) {
            String modelName = this.fModelManager.getModel().getName();
            this.setModelNameProperty(modelName);
            this.setHasUnsavedChanges(false);
        }
        return saved;
    }

    public void exportModel(PlantModelExporter exporter) {
    }

    public ModelComponent createModelComponent(Class<? extends ModelComponent> clazz) {
        return null;
    }

    private OpenTCSDrawingView getActiveDrawingView() {
        return this.fDrawingEditor.getActiveView();
    }

    private void removeDrawingView(DefaultSingleCDockable dock) {
        if (!this.viewManager.getDrawingViewMap().containsKey(dock)) {
            return;
        }
        this.fDrawingEditor.remove((DrawingView)((DrawingViewScrollPane)this.viewManager.getDrawingViewMap().get(dock)).getDrawingView());
        this.viewManager.removeDockable(dock);
        this.dockingManager.removeDockable((SingleCDockable)dock);
    }

    private JPanel wrapViewComponent() {
        JToolBar toolBar = new JToolBar();
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new BoxLayout(toolBarPanel, 2));
        toolBar.setBorder((Border)new PaletteToolBarBorder());
        LinkedList<JToolBar> lToolBars = new LinkedList<JToolBar>();
        JPanel wholeComponentPanel = new JPanel(new BorderLayout());
        wholeComponentPanel.add((Component)toolBarPanel, "North");
        wholeComponentPanel.add(this.getComponent());
        lToolBars.add(toolBar);
        JPanel viewComponent = wholeComponentPanel;
        for (JToolBar curToolBar : new ReversedList(this.toolBarManager.getToolBars())) {
            JPanel curToolBarPanel = new JPanel();
            curToolBarPanel.setLayout(new BoxLayout(curToolBarPanel, 2));
            JPanel wrappingPanel = new JPanel(new BorderLayout());
            curToolBar.setBorder((Border)new PaletteToolBarBorder());
            curToolBarPanel.add(curToolBar);
            wrappingPanel.add((Component)curToolBarPanel, "North");
            wrappingPanel.add(viewComponent);
            lToolBars.add(curToolBar);
            viewComponent = wrappingPanel;
        }
        for (JToolBar bar : lToolBars) {
            this.configureToolBarButtons(bar);
        }
        return viewComponent;
    }

    private void configureToolBarButtons(JToolBar bar) {
        Dimension dimButton = new Dimension(32, 34);
        for (Component comp : bar.getComponents()) {
            if (!(comp instanceof JButton) && !(comp instanceof JToggleButton)) continue;
            JComponent tbButton = (JComponent)comp;
            tbButton.setMaximumSize(dimButton);
            tbButton.setPreferredSize(dimButton);
            tbButton.setBorder(new EtchedBorder());
        }
    }

    private void closeOpenedPluginPanels() {
        for (PluggablePanelFactory factory : this.panelRegistry.getFactories()) {
            this.showPluginPanel(factory, false);
        }
    }

    private void setOperatingState() {
        this.appState.setOperationMode(OperationMode.OPERATING);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                OpenTCSView.this.eventBus.onEvent((Object)new OperationModeChangeEvent((Object)this, OperationMode.UNDEFINED, OperationMode.OPERATING));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(run);
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOG.error("Unexpected exception ", (Throwable)ex);
            }
        }
        this.eventBus.onEvent((Object)new ResetInteractionToolCommand((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeModelComponent(ModelComponent folder, ModelComponent model) {
        if (!folder.contains(model)) {
            return false;
        }
        boolean componentRemoved = false;
        ModelComponent modelComponent = model;
        synchronized (modelComponent) {
            if (!BlockModel.class.isInstance(folder)) {
                ModelComponent modelComponent2 = folder;
                synchronized (modelComponent2) {
                    folder.remove(model);
                }
                model.removeAttributesChangeListener(this.attributesEventHandler);
                componentRemoved = true;
            }
            this.fPropertiesComponent.reset();
            if (model instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)model;
                this.fBlocksTreeManager.removeItem((Object)blockModel);
                blockModel.blockRemoved();
                blockModel.removeBlockChangeListener(this.blockEventHandler);
            } else if (componentRemoved) {
                this.fComponentsTreeManager.removeItem((Object)model);
            }
            if (model instanceof LocationTypeModel) {
                for (LocationModel location : this.fModelManager.getModel().getLocationModels()) {
                    location.updateTypeProperty(this.fModelManager.getModel().getLocationTypeModels());
                }
            }
            this.setHasUnsavedChanges(true);
        }
        return componentRemoved;
    }

    private Figure findFigure(ModelComponent model) {
        return this.fModelManager.getModel().getFigure(model);
    }

    private void setSystemModel(SystemModel systemModel) {
        Objects.requireNonNull(systemModel, "systemModel");
        long timeBefore = System.currentTimeMillis();
        for (DrawingViewScrollPane scrollPane : this.viewManager.getDrawingViewMap().values()) {
            scrollPane.originChanged(systemModel.getDrawingMethod().getOrigin());
        }
        this.fDrawingEditor.setSystemModel(systemModel);
        Drawing drawing = this.fDrawingEditor.getDrawing();
        drawing.addUndoableEditListener((UndoableEditListener)this.fUndoRedoManager);
        this.fComponentsTreeManager.restoreTreeView((ModelComponent)systemModel);
        this.fComponentsTreeManager.sortItems();
        this.fComponentsTreeManager.getTreeView().getTree().scrollRowToVisible(0);
        this.fBlocksTreeManager.restoreTreeView(systemModel.getMainFolder(SystemModel.FolderKey.BLOCKS));
        this.fBlocksTreeManager.getTreeView().sortRoot();
        this.fBlocksTreeManager.getTreeView().getTree().scrollRowToVisible(0);
        for (VehicleModel vehicle : systemModel.getVehicleModels()) {
            vehicle.addAttributesChangeListener(this.attributesEventHandler);
        }
        systemModel.getLayoutModel().addAttributesChangeListener(this.attributesEventHandler);
        for (PointModel point : systemModel.getPointModels()) {
            point.addAttributesChangeListener(this.attributesEventHandler);
        }
        for (PathModel path : systemModel.getPathModels()) {
            path.addAttributesChangeListener(this.attributesEventHandler);
        }
        for (LocationTypeModel locationType : systemModel.getLocationTypeModels()) {
            locationType.addAttributesChangeListener(this.attributesEventHandler);
        }
        for (LocationModel location : systemModel.getLocationModels()) {
            location.addAttributesChangeListener(this.attributesEventHandler);
        }
        for (LinkModel link : systemModel.getLinkModels()) {
            link.addAttributesChangeListener(this.attributesEventHandler);
        }
        for (BlockModel block : systemModel.getBlockModels()) {
            block.addAttributesChangeListener(this.attributesEventHandler);
            block.addBlockChangeListener(this.blockEventHandler);
        }
        LOG.debug("setSystemModel() took {} ms.", (Object)(System.currentTimeMillis() - timeBefore));
    }

    private void initializeFrame() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.initializeFrame());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.warn("Exception initializing frame", (Throwable)e);
            }
            return;
        }
        this.fFrame.getContentPane().removeAll();
        this.dockingManager.initializeDockables();
        this.fFrame.setLayout(new BorderLayout());
        this.fFrame.add((Component)this.wrapViewComponent(), "North");
        this.fFrame.add((Component)this.dockingManager.getCControl().getContentArea());
        this.fFrame.add((Component)this.statusPanel, "South");
        this.restoreDockables();
        this.toolBarManager.getDragToolButton().doClick();
        this.toolBarManager.getSelectionToolButton().doClick();
    }

    private void restoreDockables() {
        this.addDrawingView();
        this.addTransportOrderView();
        this.addTransportOrderSequenceView();
        if (this.configuration.enablePeripheralJobsPanel()) {
            this.addPeripheralJobsView();
        }
        ((CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation()).setFrontDockable((Dockable)this.viewManager.evaluateFrontDockable());
    }

    private class BlockEventHandler
    implements BlockChangeListener {
        BlockEventHandler() {
        }

        public void courseElementsChanged(BlockChangeEvent event) {
            BlockModel block = (BlockModel)event.getSource();
            OpenTCSView.this.fBlocksTreeManager.removeChildren((Object)block);
            for (ModelComponent component : block.getChildComponents()) {
                OpenTCSView.this.fBlocksTreeManager.addItem((Object)block, component);
            }
            OpenTCSView.this.setHasUnsavedChanges(true);
        }

        public void colorChanged(BlockChangeEvent event) {
        }

        public void blockRemoved(BlockChangeEvent event) {
        }
    }

    private class AttributesEventHandler
    implements AttributesChangeListener {
        AttributesEventHandler() {
        }

        public void propertiesChanged(AttributesChangeEvent event) {
            if (event.getInitiator() == this) {
                return;
            }
            ModelComponent model = event.getModel();
            if (model.getPropertyName() != null && model.getPropertyName().hasChanged()) {
                OpenTCSView.this.fComponentsTreeManager.itemChanged((Object)model);
                OpenTCSView.this.fModelManager.getModel().getBlockModels().stream().filter(block -> this.blockAffectedByNameChange((BlockModel)block, model)).forEach(block -> this.updateBlockMembers((BlockModel)block));
            }
            if (model instanceof LayoutModel) {
                LengthProperty pScaleX = (LengthProperty)model.getProperty("scaleX");
                LengthProperty pScaleY = (LengthProperty)model.getProperty("scaleY");
                if (pScaleX.hasChanged() || pScaleY.hasChanged()) {
                    double scaleX = (Double)pScaleX.getValue();
                    double scaleY = (Double)pScaleY.getValue();
                    if (scaleX != 0.0 && scaleY != 0.0) {
                        OpenTCSView.this.fModelManager.getModel().getDrawingMethod().getOrigin().setScale(scaleX, scaleY);
                    }
                }
            }
            if (model instanceof LocationModel && model.getProperty("Type").hasChanged()) {
                AbstractProperty p = (AbstractProperty)model.getProperty("Type");
                LocationTypeModel type = OpenTCSView.this.fModelManager.getModel().getLocationTypeModel((String)p.getValue());
                ((LocationModel)model).setLocationType(type);
                if (model != event.getInitiator()) {
                    model.propertiesChanged((AttributesChangeListener)this);
                }
            }
            if (model instanceof LocationTypeModel) {
                for (LocationModel locModel : OpenTCSView.this.fModelManager.getModel().getLocationModels()) {
                    locModel.updateTypeProperty(OpenTCSView.this.fModelManager.getModel().getLocationTypeModels());
                }
            }
        }

        private boolean blockAffectedByNameChange(BlockModel block, ModelComponent model) {
            return block.getChildComponents().stream().anyMatch(member -> member.equals(model));
        }

        private void updateBlockMembers(BlockModel block) {
            ArrayList<String> members = new ArrayList<String>();
            for (ModelComponent component : block.getChildComponents()) {
                members.add(component.getName());
            }
            block.getPropertyElements().setItems(members);
        }
    }

    private class DrawingEditorEventHandler
    implements DrawingEditorListener {
        private final ModelManager modelManager;

        DrawingEditorEventHandler(ModelManager modelManager) {
            this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        }

        public void figureAdded(DrawingEditorEvent event) {
            Origin ref;
            Figure figure = event.getFigure();
            ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
            if (model == null) {
                return;
            }
            if (figure instanceof AttributesChangeListener) {
                model.addAttributesChangeListener((AttributesChangeListener)figure);
            }
            if (figure instanceof OriginChangeListener && (ref = this.modelManager.getModel().getDrawingMethod().getOrigin()) != null) {
                ref.addListener((OriginChangeListener)figure);
                figure.set(FigureConstants.ORIGIN, (Object)ref);
            }
            OpenTCSView.this.fModelManager.getModel().registerFigure(model, figure);
            if (figure instanceof LabeledFigure) {
                ((LabeledFigure)figure).updateModel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void figureRemoved(DrawingEditorEvent e) {
            Figure figure = e.getFigure();
            if (figure == null) {
                return;
            }
            ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
            if (model == null) {
                return;
            }
            ModelComponent modelComponent = model;
            synchronized (modelComponent) {
                ModelComponent folder;
                Origin ref;
                if (figure instanceof OriginChangeListener && (ref = (Origin)figure.get(FigureConstants.ORIGIN)) != null) {
                    ref.removeListener((OriginChangeListener)figure);
                    figure.set(FigureConstants.ORIGIN, null);
                }
                this.removeFromAllBlocks(model);
                ModelComponent modelComponent2 = folder = this.modelManager.getModel().getFolder(model);
                synchronized (modelComponent2) {
                    OpenTCSView.this.removeModelComponent(folder, model);
                }
            }
        }

        public void figureSelected(DrawingEditorEvent event) {
            if (event.getCount() == 0) {
                OpenTCSView.this.fComponentsTreeManager.selectItems(null);
                OpenTCSView.this.fBlocksTreeManager.selectItems(null);
            } else if (event.getCount() == 1) {
                ModelComponent model;
                Figure figure = event.getFigure();
                if (figure != null && (model = (ModelComponent)figure.get(FigureConstants.MODEL)) != null) {
                    model.addAttributesChangeListener(OpenTCSView.this.attributesEventHandler);
                    OpenTCSView.this.fPropertiesComponent.setModel(model);
                    OpenTCSView.this.fComponentsTreeManager.selectItem(model);
                    OpenTCSView.this.fBlocksTreeManager.selectItem(model);
                }
            } else {
                LinkedList<ModelComponent> models = new LinkedList<ModelComponent>();
                HashSet<ModelComponent> components = new HashSet<ModelComponent>();
                for (Figure figure : event.getFigures()) {
                    ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
                    if (model == null) continue;
                    models.add(model);
                    components.add(model);
                }
                PropertiesCollection model = new PropertiesCollection(models);
                OpenTCSView.this.fComponentsTreeManager.selectItems(components);
                OpenTCSView.this.fBlocksTreeManager.selectItems(components);
                OpenTCSView.this.fPropertiesComponent.setModel((ModelComponent)model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromAllBlocks(ModelComponent model) {
            ModelComponent mainFolder;
            ModelComponent modelComponent = mainFolder = this.modelManager.getModel().getMainFolder(SystemModel.FolderKey.BLOCKS);
            synchronized (modelComponent) {
                for (ModelComponent blockModelComp : mainFolder.getChildComponents()) {
                    BlockModel block = (BlockModel)blockModelComp;
                    ArrayList<ModelComponent> elementsToRemove = new ArrayList<ModelComponent>();
                    for (ModelComponent blockChildComp : block.getChildComponents()) {
                        if (model != blockChildComp) continue;
                        elementsToRemove.add(blockChildComp);
                    }
                    if (elementsToRemove.isEmpty()) continue;
                    for (ModelComponent mc : elementsToRemove) {
                        block.removeCourseElement(mc);
                    }
                    block.courseElementsChanged();
                }
            }
        }
    }

    private class VehicleDragHandler
    extends MouseAdapter {
        private final Cursor dragCursor;
        private VehicleModel vehicleModel;

        VehicleDragHandler(Cursor dragCursor) {
            this.dragCursor = Objects.requireNonNull(dragCursor, "dragCursor");
        }

        @Override
        public void mousePressed(MouseEvent e) {
            UserObject object = OpenTCSView.this.fComponentsTreeManager.getDraggedUserObject(e);
            this.vehicleModel = object instanceof VehicleUserObject ? ((VehicleUserObject)object).getModelComponent() : null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.vehicleModel == null) {
                return;
            }
            Point eOnScreen = e.getLocationOnScreen();
            for (OpenTCSDrawingView drawView : OpenTCSView.this.getDrawingViews()) {
                if (!drawView.getComponent().isShowing() || !drawView.containsPointOnScreen(eOnScreen)) continue;
                drawView.setCursor(this.dragCursor);
            }
            OpenTCSView.this.fComponentsTreeManager.setCursor(this.dragCursor);
            OpenTCSView.this.setCursor(this.dragCursor);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            OpenTCSView.this.fComponentsTreeManager.setCursor(Cursor.getDefaultCursor());
            OpenTCSView.this.setCursor(Cursor.getDefaultCursor());
            this.vehicleModel = null;
            if (this.vehicleModel != null && (Vehicle.ProcState)this.vehicleModel.getPropertyProcState().getValue() == Vehicle.ProcState.IDLE) {
                this.createOrderToPointOnScreen(event.getLocationOnScreen());
            }
        }

        private void createOrderToPointOnScreen(Point locationOnScreen) {
            for (OpenTCSDrawingView drawView : OpenTCSView.this.getDrawingViews()) {
                Figure figure;
                drawView.setCursor(Cursor.getDefaultCursor());
                if (!drawView.getComponent().isShowing() || !drawView.containsPointOnScreen(locationOnScreen) || !((figure = this.getFigureAtPointInView(locationOnScreen, drawView)) instanceof LabeledPointFigure)) continue;
                this.createOrderToPointFigure((LabeledPointFigure)figure);
            }
        }

        private Figure getFigureAtPointInView(Point locationOnScreen, OpenTCSDrawingView drawView) {
            Point drawingViewOnScreen = drawView.getComponent().getLocationOnScreen();
            Point drawingViewPoint = new Point(locationOnScreen.x - drawingViewOnScreen.x, locationOnScreen.y - drawingViewOnScreen.y);
            return drawView.findFigure(drawingViewPoint);
        }

        private void createOrderToPointFigure(LabeledPointFigure figure) {
            PointModel model = (PointModel)figure.get(FigureConstants.MODEL);
            OpenTCSView.this.orderUtil.createTransportOrder(model, this.vehicleModel);
        }
    }

    private class DrawingViewClosingListener
    implements CVetoClosingListener {
        private final DefaultSingleCDockable newDockable;

        DrawingViewClosingListener(DefaultSingleCDockable newDockable) {
            this.newDockable = newDockable;
        }

        public void closing(CVetoClosingEvent event) {
        }

        public void closed(CVetoClosingEvent event) {
            if (this.newDockable.isCloseable()) {
                OpenTCSView.this.removeDrawingView(this.newDockable);
            }
        }
    }
}

