/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.common.application.AbstractViewManager;
import org.opentcs.guing.common.components.dockable.CStackDockStation;
import org.opentcs.guing.common.components.dockable.DockableTitleComparator;
import org.opentcs.guing.common.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingView;
import org.opentcs.operationsdesk.components.dockable.DockingManagerOperating;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobsContainerPanel;
import org.opentcs.operationsdesk.transport.orders.TransportOrdersContainerPanel;
import org.opentcs.operationsdesk.transport.sequences.OrderSequencesContainerPanel;
import org.opentcs.util.event.EventSource;

public class ViewManagerOperating
extends AbstractViewManager {
    private final DockingManagerOperating dockingManager;
    private final EventSource eventSource;
    private final Map<DefaultSingleCDockable, TransportOrdersContainerPanel> transportOrderViews;
    private final Map<DefaultSingleCDockable, OrderSequencesContainerPanel> orderSequenceViews;
    private final Map<DefaultSingleCDockable, PeripheralJobsContainerPanel> peripheralJobViews;

    @Inject
    public ViewManagerOperating(DockingManagerOperating dockingManager, @ApplicationEventBus EventSource eventSource) {
        super(eventSource);
        this.dockingManager = Objects.requireNonNull(dockingManager, "dockingManager");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
        this.transportOrderViews = new TreeMap<DefaultSingleCDockable, TransportOrdersContainerPanel>((Comparator<DefaultSingleCDockable>)new DockableTitleComparator());
        this.orderSequenceViews = new TreeMap<DefaultSingleCDockable, OrderSequencesContainerPanel>((Comparator<DefaultSingleCDockable>)new DockableTitleComparator());
        this.peripheralJobViews = new TreeMap<DefaultSingleCDockable, PeripheralJobsContainerPanel>((Comparator<DefaultSingleCDockable>)new DockableTitleComparator());
    }

    public void init() {
        this.setPlantOverviewStateOperating();
    }

    public void reset() {
        super.reset();
        this.transportOrderViews.clear();
        this.orderSequenceViews.clear();
        this.peripheralJobViews.clear();
    }

    public Map<DefaultSingleCDockable, TransportOrdersContainerPanel> getTransportOrderMap() {
        return this.transportOrderViews;
    }

    public Map<DefaultSingleCDockable, OrderSequencesContainerPanel> getOrderSequenceMap() {
        return this.orderSequenceViews;
    }

    public Map<DefaultSingleCDockable, PeripheralJobsContainerPanel> getPeripheralJobMap() {
        return this.peripheralJobViews;
    }

    public List<OpenTCSDrawingView> getOperatingDrawingViews() {
        return this.getDrawingViewMap().entrySet().stream().map(entry -> ((DrawingViewScrollPane)entry.getValue()).getDrawingView()).collect(Collectors.toList());
    }

    public int getNextTransportOrderViewIndex() {
        return this.nextAvailableIndex(this.transportOrderViews.keySet());
    }

    public int getNextOrderSequenceViewIndex() {
        return this.nextAvailableIndex(this.orderSequenceViews.keySet());
    }

    public int getNextPeripheralJobViewIndex() {
        return this.nextAvailableIndex(this.peripheralJobViews.keySet());
    }

    public DefaultSingleCDockable getLastTransportOrderView() {
        int biggestIndex = this.getNextTransportOrderViewIndex();
        DefaultSingleCDockable lastTOView = null;
        Iterator<DefaultSingleCDockable> tranportOrderViewIterator = this.transportOrderViews.keySet().iterator();
        for (int i = 0; i < biggestIndex; ++i) {
            if (!tranportOrderViewIterator.hasNext()) continue;
            lastTOView = tranportOrderViewIterator.next();
        }
        return lastTOView;
    }

    public DefaultSingleCDockable getLastOrderSequenceView() {
        int biggestIndex = this.getNextOrderSequenceViewIndex();
        DefaultSingleCDockable lastOSView = null;
        Iterator<DefaultSingleCDockable> orderSequencesViewIterator = this.orderSequenceViews.keySet().iterator();
        for (int i = 0; i < biggestIndex; ++i) {
            if (!orderSequencesViewIterator.hasNext()) continue;
            lastOSView = orderSequencesViewIterator.next();
        }
        return lastOSView;
    }

    public DefaultSingleCDockable getLastPeripheralJobView() {
        int biggestIndex = this.getNextPeripheralJobViewIndex();
        DefaultSingleCDockable lastView = null;
        Iterator<DefaultSingleCDockable> peripheralJobViewIterator = this.peripheralJobViews.keySet().iterator();
        for (int i = 0; i < biggestIndex; ++i) {
            if (!peripheralJobViewIterator.hasNext()) continue;
            lastView = peripheralJobViewIterator.next();
        }
        return lastView;
    }

    public void addTransportOrderView(DefaultSingleCDockable dockable, TransportOrdersContainerPanel panel) {
        Objects.requireNonNull(dockable, "dockable");
        Objects.requireNonNull(panel, "panel");
        this.transportOrderViews.put(dockable, panel);
    }

    public void addOrderSequenceView(DefaultSingleCDockable dockable, OrderSequencesContainerPanel panel) {
        Objects.requireNonNull(dockable, "dockable");
        Objects.requireNonNull(panel, "panel");
        this.orderSequenceViews.put(dockable, panel);
    }

    public void addPeripheralJobView(DefaultSingleCDockable dockable, PeripheralJobsContainerPanel panel) {
        Objects.requireNonNull(dockable, "dockable");
        Objects.requireNonNull(panel, "panel");
        this.peripheralJobViews.put(dockable, panel);
    }

    public void removeDockable(DefaultSingleCDockable dockable) {
        super.removeDockable(dockable);
        this.transportOrderViews.remove(dockable);
        this.orderSequenceViews.remove(dockable);
        this.peripheralJobViews.remove(dockable);
    }

    public DefaultCommonDockable evaluateFrontDockable() {
        if (!this.getDrawingViewMap().isEmpty()) {
            return ((DefaultSingleCDockable)this.getDrawingViewMap().keySet().iterator().next()).intern();
        }
        if (!this.transportOrderViews.isEmpty()) {
            return this.transportOrderViews.keySet().iterator().next().intern();
        }
        if (!this.orderSequenceViews.isEmpty()) {
            return this.orderSequenceViews.keySet().iterator().next().intern();
        }
        if (!this.peripheralJobViews.isEmpty()) {
            return this.peripheralJobViews.keySet().iterator().next().intern();
        }
        return null;
    }

    private void setPlantOverviewStateOperating() {
        CStackDockStation station = (CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation();
        Dockable frontDock = station.getFrontDockable();
        int i = 0;
        for (DefaultSingleCDockable dock : new ArrayList(this.getDrawingViewMap().keySet())) {
            dock.setCloseable(true);
            this.dockingManager.showDockable(station, dock, i);
            ++i;
        }
        i = this.getDrawingViewMap().size();
        for (DefaultSingleCDockable dock : new ArrayList(this.getDrawingViewMap().keySet())) {
            if (!this.dockingManager.isDockableDocked(station, dock)) continue;
            --i;
        }
        int dockedDrawingViews = i;
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.transportOrderViews.keySet())) {
            this.dockingManager.showDockable(station, dock, i);
            ++i;
        }
        i = dockedDrawingViews + this.transportOrderViews.size();
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.orderSequenceViews.keySet())) {
            this.dockingManager.showDockable(station, dock, i);
            ++i;
        }
        for (DefaultSingleCDockable dock : new ArrayList<DefaultSingleCDockable>(this.peripheralJobViews.keySet())) {
            this.dockingManager.showDockable(station, dock, i);
            ++i;
        }
        if (frontDock != null && frontDock.isDockableShowing()) {
            station.setFrontDockable(frontDock);
        } else {
            station.setFrontDockable(station.getDockable(0));
        }
        this.dockingManager.setDockableVisibility("vehicles_dock", true);
    }
}

