/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.actions;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.model.SystemModel;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeAllVehiclesAction
extends AbstractAction {
    public static final String ID = "openTCS.resumeAllVehicles";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.toolbar");
    private static final Logger LOG = LoggerFactory.getLogger(ResumeAllVehiclesAction.class);
    private final ModelManager modelManager;
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public ResumeAllVehiclesAction(ModelManager modelManager, SharedKernelServicePortalProvider portalProvider) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.putValue("Name", BUNDLE.getString("resumeAllVehiclesAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("resumeAllVehiclesAction.shortDescription"));
        ImageIcon iconSmall = ImageDirectory.getImageIcon((String)"/toolbar/resume-vehicles.16.png");
        ImageIcon iconLarge = ImageDirectory.getImageIcon((String)"/toolbar/resume-vehicles.22.png");
        this.putValue("SmallIcon", iconSmall);
        this.putValue("SwingLargeIconKey", iconLarge);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            this.resumeVehicles(sharedPortal.getPortal());
        }
        catch (ServiceUnavailableException exc) {
            LOG.warn("Could not connect to kernel", (Throwable)exc);
        }
    }

    private void resumeVehicles(KernelServicePortal portal) {
        if (portal == null) {
            return;
        }
        ModelComponent folder = this.modelManager.getModel().getMainFolder(SystemModel.FolderKey.VEHICLES);
        if (this.portalProvider.portalShared()) {
            for (ModelComponent component : folder.getChildComponents()) {
                VehicleModel vModel = (VehicleModel)component;
                LOG.info("Resuming vehicle {}...", (Object)vModel.getVehicle().getName());
                portal.getVehicleService().updateVehiclePaused(vModel.getVehicle().getReference(), false);
            }
        }
    }
}

