/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingView;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class FollowVehicleAction
extends AbstractAction {
    public static final String ID = "course.vehicle.follow";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final VehicleModel vehicleModel;
    private final OpenTCSDrawingEditor drawingEditor;

    @Inject
    public FollowVehicleAction(@Assisted VehicleModel vehicle, OpenTCSDrawingEditor drawingEditor) {
        this.vehicleModel = Objects.requireNonNull(vehicle, "vehicle");
        this.drawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.putValue("Name", BUNDLE.getString("followVehicleAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)evt.getSource();
        OpenTCSDrawingView drawingView = this.drawingEditor.getActiveView();
        if (drawingView != null) {
            if (checkBox.isSelected()) {
                drawingView.followVehicle(this.vehicleModel);
            } else {
                drawingView.stopFollowVehicle();
            }
        }
    }
}

