/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationLevelChangeAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationLevelChangeAction.class);
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final Collection<VehicleModel> vehicles;
    private final Vehicle.IntegrationLevel level;
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public IntegrationLevelChangeAction(@Assisted Collection<VehicleModel> vehicles, @Assisted Vehicle.IntegrationLevel level, SharedKernelServicePortalProvider portalProvider) {
        String actionName;
        this.vehicles = Objects.requireNonNull(vehicles, "vehicles");
        this.level = Objects.requireNonNull(level, "level");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        switch (level) {
            case TO_BE_NOTICED: {
                actionName = this.bundle.getString("integrationLevelChangeAction.notice.name");
                break;
            }
            case TO_BE_RESPECTED: {
                actionName = this.bundle.getString("integrationLevelChangeAction.respect.name");
                break;
            }
            case TO_BE_UTILIZED: {
                actionName = this.bundle.getString("integrationLevelChangeAction.utilize.name");
                break;
            }
            default: {
                actionName = this.bundle.getString("integrationLevelChangeAction.ignore.name");
            }
        }
        this.putValue("Name", actionName);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            for (VehicleModel vehicle : this.vehicles) {
                sharedPortal.getPortal().getVehicleService().updateVehicleIntegrationLevel(vehicle.getVehicle().getReference(), this.level);
            }
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }
}

