/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PauseAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(PauseAction.class);
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final Collection<VehicleModel> vehicles;
    private final boolean pause;
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public PauseAction(@Assisted Collection<VehicleModel> vehicles, @Assisted boolean pause, SharedKernelServicePortalProvider portalProvider) {
        this.vehicles = Objects.requireNonNull(vehicles, "vehicles");
        this.pause = Objects.requireNonNull(Boolean.valueOf(pause), "pause");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.putValue("Name", pause ? this.bundle.getString("pauseAction.pause.name") : this.bundle.getString("pauseAction.resume.name"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            for (VehicleModel vehicle : this.vehicles) {
                sharedPortal.getPortal().getVehicleService().updateVehiclePaused(vehicle.getVehicle().getReference(), this.pause);
            }
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }
}

