/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.base.model.AbstractConnectableModelComponent;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.guing.common.components.dialogs.StandardContentDialog;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.exchange.TransportOrderUtil;
import org.opentcs.operationsdesk.transport.LocationActionPanel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class SendVehicleToLocationAction
extends AbstractAction {
    public static final String ID = "course.vehicle.sendToLocation";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private final VehicleModel fVehicle;
    private final JFrame applicationFrame;
    private final ModelManager modelManager;
    private final TransportOrderUtil orderUtil;

    @Inject
    public SendVehicleToLocationAction(@Assisted VehicleModel vehicle, @ApplicationFrame JFrame applicationFrame, ModelManager modelManager, TransportOrderUtil orderUtil) {
        this.fVehicle = Objects.requireNonNull(vehicle, "vehicle");
        this.applicationFrame = Objects.requireNonNull(applicationFrame, "applicationFrame");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.orderUtil = Objects.requireNonNull(orderUtil, "orderUtil");
        this.putValue("Name", BUNDLE.getString("sendVehicleToLocationAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        List<LocationModel> locModels = this.locationModels();
        if (!locModels.isEmpty()) {
            LocationActionPanel contentPanel = new LocationActionPanel(locModels);
            StandardContentDialog fDialog = new StandardContentDialog((Component)this.applicationFrame, (DialogContent)contentPanel);
            fDialog.setTitle(evt.getActionCommand());
            fDialog.setVisible(true);
            if (fDialog.getReturnStatus() == 1) {
                LocationModel location = contentPanel.getSelectedLocation();
                ArrayList<AbstractConnectableModelComponent> destinationModels = new ArrayList<AbstractConnectableModelComponent>();
                destinationModels.add((AbstractConnectableModelComponent)location);
                ArrayList<String> actions = new ArrayList<String>();
                actions.add(contentPanel.getSelectedAction());
                this.orderUtil.createTransportOrder(destinationModels, actions, System.currentTimeMillis(), this.fVehicle, "-");
            }
        }
    }

    private List<LocationModel> locationModels() {
        return this.modelManager.getModel().getLocationModels();
    }
}

