/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.application.action.course;

import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithdrawAction
extends AbstractAction {
    public static final String ID = "course.vehicle.withdrawTransportOrder";
    public static final String IMMEDIATELY_ID = "course.vehicle.withdrawTransportOrderImmediately";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup");
    private static final Logger LOG = LoggerFactory.getLogger(WithdrawAction.class);
    private final Collection<VehicleModel> vehicles;
    private final boolean immediateAbort;
    private final SharedKernelServicePortalProvider portalProvider;
    private final Component dialogParent;

    @Inject
    public WithdrawAction(@Assisted Collection<VehicleModel> vehicles, @Assisted boolean immediateAbort, SharedKernelServicePortalProvider portalProvider, @ApplicationFrame Component dialogParent) {
        this.vehicles = Objects.requireNonNull(vehicles, "vehicles");
        this.immediateAbort = Objects.requireNonNull(Boolean.valueOf(immediateAbort), "immediateAbort");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        if (immediateAbort) {
            this.putValue("Name", BUNDLE.getString("withdrawAction.withdrawImmediately.name"));
        } else {
            this.putValue("Name", BUNDLE.getString("withdrawAction.withdraw.name"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int dialogResult;
        if (this.immediateAbort && (dialogResult = JOptionPane.showConfirmDialog(this.dialogParent, BUNDLE.getString("withdrawAction.optionPane_confirmWithdraw.message"), BUNDLE.getString("withdrawAction.optionPane_confirmWithdraw.title"), 2, 2)) != 0) {
            return;
        }
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            for (VehicleModel vehicle : this.vehicles) {
                sharedPortal.getPortal().getDispatcherService().withdrawByVehicle(vehicle.getVehicle().getReference(), this.immediateAbort);
            }
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
    }
}

