/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.dialogs;

import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.Figure;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.base.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.common.components.properties.SelectionPropertiesComponent;
import org.opentcs.guing.common.components.tree.ComponentsTreeViewManager;
import org.opentcs.guing.common.components.tree.TreeViewManager;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.application.menus.MenuFactory;
import org.opentcs.operationsdesk.components.drawing.figures.VehicleFigure;
import org.opentcs.operationsdesk.util.VehicleCourseObjectFactory;

public class SingleVehicleView
extends JPanel
implements AttributesChangeListener,
Comparable<SingleVehicleView> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.panels.vehicleView");
    private static final Color ORANGE = new Color(255, 221, 117);
    private static final Color GREEN = new Color(119, 219, 108);
    private final VehicleModel fVehicleModel;
    private final TreeViewManager treeViewManager;
    private final SelectionPropertiesComponent propertiesComponent;
    private final OpenTCSDrawingEditor drawingEditor;
    private final MenuFactory menuFactory;
    private final ModelManager modelManager;
    private final JPanel fVehicleView;
    private JLabel batteryIcon;
    private JLabel batteryLabel;
    private JPanel batteryPanel;
    private JLabel destinationLabel;
    private JLabel destinationValueLabel;
    private JLabel fillLabel;
    private JLabel integratedLabel;
    private JLabel integratedStateLabel;
    private JLabel positionLabel;
    private JLabel positionValueLabel;
    private JPanel propertiesPanel;
    private JPanel statusPanel;
    private JLabel vehicleLabel;
    private JPanel vehiclePanel;
    private JLabel vehicleStateLabel;
    private JLabel vehicleStateValueLabel;

    @Inject
    public SingleVehicleView(@Assisted VehicleModel vehicle, ComponentsTreeViewManager treeViewManager, SelectionPropertiesComponent propertiesComponent, OpenTCSDrawingEditor drawingEditor, VehicleCourseObjectFactory crsObjFactory, MenuFactory menuFactory, ModelManager modelManager) {
        this.fVehicleModel = Objects.requireNonNull(vehicle, "vehicle");
        this.treeViewManager = (TreeViewManager)Objects.requireNonNull(treeViewManager, "treeViewManager");
        this.propertiesComponent = Objects.requireNonNull(propertiesComponent, "propertiesComponent");
        this.drawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.menuFactory = Objects.requireNonNull(menuFactory, "menuFactory");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        Objects.requireNonNull(crsObjFactory, "crsObjFactory");
        this.fVehicleView = new VehicleView(this.fVehicleModel, crsObjFactory.createVehicleFigure(this.fVehicleModel));
        this.initComponents();
        this.vehiclePanel.add((Component)this.fVehicleView, "Center");
        vehicle.addAttributesChangeListener((AttributesChangeListener)this);
        this.vehicleLabel.setText(vehicle.getName());
        this.updateVehicle();
    }

    private void showPopup(int x, int y) {
        this.menuFactory.createVehiclePopupMenu(Arrays.asList(this.fVehicleModel)).show(this, x, y);
    }

    private void updateVehicle() {
        this.updateVehicleIntegrationLevel();
        this.updateVehicleState();
        this.updateVehiclePosition();
        this.updateEnergyLevel();
        this.updateVehicleDestination();
        this.revalidate();
    }

    private void updateVehicleDestination() {
        PointModel destinationPoint = this.getVehicleModel().getDriveOrderDestination();
        if (destinationPoint != null) {
            this.destinationValueLabel.setText(destinationPoint.getName());
        } else {
            this.destinationValueLabel.setText("-");
        }
    }

    private void updateVehicleIntegrationLevel() {
        Vehicle.IntegrationLevel integrationLevel = (Vehicle.IntegrationLevel)this.fVehicleModel.getPropertyIntegrationLevel().getValue();
        switch (integrationLevel) {
            case TO_BE_IGNORED: 
            case TO_BE_NOTICED: {
                this.integratedStateLabel.setText(BUNDLE.getString("singleVehicleView.label_integratedState.no.text"));
                this.integratedStateLabel.setOpaque(false);
                break;
            }
            case TO_BE_RESPECTED: {
                this.integratedStateLabel.setText(BUNDLE.getString("singleVehicleView.label_integratedState.partially.text"));
                this.integratedStateLabel.setOpaque(true);
                this.integratedStateLabel.setBackground(ORANGE);
                break;
            }
            case TO_BE_UTILIZED: {
                this.integratedStateLabel.setText(BUNDLE.getString("singleVehicleView.label_integratedState.fully.text"));
                this.integratedStateLabel.setOpaque(true);
                this.integratedStateLabel.setBackground(GREEN);
                break;
            }
            default: {
                this.integratedStateLabel.setText(integrationLevel.name());
                this.integratedStateLabel.setOpaque(false);
            }
        }
    }

    private void updateVehicleState() {
        Vehicle.State state = (Vehicle.State)this.fVehicleModel.getPropertyState().getValue();
        this.vehicleStateValueLabel.setText(state.toString());
        switch (state) {
            case ERROR: 
            case UNAVAILABLE: 
            case UNKNOWN: {
                this.vehicleStateValueLabel.setBackground(ORANGE);
                this.vehicleStateValueLabel.setOpaque(true);
                break;
            }
            default: {
                this.vehicleStateValueLabel.setOpaque(false);
            }
        }
    }

    private void updateVehiclePosition() {
        this.positionValueLabel.setText(this.fVehicleModel.getPropertyPoint().getText());
    }

    private void updateEnergyLevel() {
        this.batteryLabel.setText(this.fVehicleModel.getPropertyEnergyLevel().getValue() + " %");
        Vehicle vehicle = this.fVehicleModel.getVehicle();
        if (vehicle.isEnergyLevelCritical()) {
            this.batteryIcon.setIcon(new ImageIcon(this.getToolkit().getImage(this.getClass().getClassLoader().getResource("org/opentcs/guing/res/symbols/panel/battery-caution-3.png"))));
        } else if (vehicle.isEnergyLevelDegraded()) {
            this.batteryIcon.setIcon(new ImageIcon(this.getToolkit().getImage(this.getClass().getClassLoader().getResource("org/opentcs/guing/res/symbols/panel/battery-060-2.png"))));
        } else if (vehicle.isEnergyLevelGood()) {
            this.batteryIcon.setIcon(new ImageIcon(this.getToolkit().getImage(this.getClass().getClassLoader().getResource("org/opentcs/guing/res/symbols/panel/battery-100-2.png"))));
        }
    }

    public VehicleModel getVehicleModel() {
        return this.fVehicleModel;
    }

    public void propertiesChanged(AttributesChangeEvent e) {
        this.updateVehicle();
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.vehiclePanel = new JPanel();
        this.vehicleLabel = new JLabel();
        this.batteryPanel = new JPanel();
        this.batteryIcon = new JLabel();
        this.batteryLabel = new JLabel();
        this.propertiesPanel = new JPanel();
        this.integratedLabel = new JLabel();
        this.integratedStateLabel = new JLabel();
        this.vehicleStateLabel = new JLabel();
        this.vehicleStateValueLabel = new JLabel();
        this.positionLabel = new JLabel();
        this.positionValueLabel = new JLabel();
        this.destinationLabel = new JLabel();
        this.destinationValueLabel = new JLabel();
        this.fillLabel = new JLabel();
        this.setMinimumSize(new Dimension(200, 59));
        this.setLayout(new GridBagLayout());
        this.statusPanel.setLayout(new BorderLayout());
        this.vehiclePanel.setLayout(new BorderLayout());
        this.vehicleLabel.setFont(this.vehicleLabel.getFont());
        this.vehicleLabel.setHorizontalAlignment(0);
        this.vehiclePanel.add((Component)this.vehicleLabel, "North");
        this.statusPanel.add((Component)this.vehiclePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.statusPanel, gridBagConstraints);
        this.batteryPanel.setMinimumSize(new Dimension(20, 14));
        this.batteryPanel.setPreferredSize(new Dimension(45, 14));
        this.batteryPanel.setLayout(new GridBagLayout());
        this.batteryPanel.add((Component)this.batteryIcon, new GridBagConstraints());
        this.batteryLabel.setText("battery");
        this.batteryLabel.setPreferredSize(new Dimension(45, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.batteryPanel.add((Component)this.batteryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.add((Component)this.batteryPanel, gridBagConstraints);
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.integratedLabel.setHorizontalAlignment(11);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/panels/vehicleView");
        this.integratedLabel.setText(bundle.getString("singleVehicleView.label_integrated.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.propertiesPanel.add((Component)this.integratedLabel, gridBagConstraints);
        this.integratedStateLabel.setText(bundle.getString("singleVehicleView.label_integratedState.no.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.propertiesPanel.add((Component)this.integratedStateLabel, gridBagConstraints);
        this.vehicleStateLabel.setHorizontalAlignment(11);
        this.vehicleStateLabel.setText(bundle.getString("singleVehicleView.label_state.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.vehicleStateLabel, gridBagConstraints);
        this.vehicleStateValueLabel.setText("UNAVAILABLE");
        this.vehicleStateValueLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.vehicleStateValueLabel, gridBagConstraints);
        this.positionLabel.setText(bundle.getString("singleVehicleView.label_position.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.positionLabel, gridBagConstraints);
        this.positionValueLabel.setText("-");
        this.positionValueLabel.setMaximumSize(new Dimension(68, 14));
        this.positionValueLabel.setMinimumSize(new Dimension(68, 14));
        this.positionValueLabel.setPreferredSize(new Dimension(68, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.positionValueLabel, gridBagConstraints);
        this.destinationLabel.setText(bundle.getString("singleVehicleView.label_destination.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.destinationLabel, gridBagConstraints);
        this.destinationValueLabel.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.propertiesPanel.add((Component)this.destinationValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertiesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fillLabel, gridBagConstraints);
    }

    @Override
    public int compareTo(SingleVehicleView o) {
        return this.fVehicleModel.getName().compareTo(o.getVehicleModel().getName());
    }

    private class VehicleView
    extends JPanel
    implements AttributesChangeListener {
        private final VehicleFigure figure;

        VehicleView(VehicleModel vehicleModel, VehicleFigure figure) {
            this.figure = Objects.requireNonNull(figure, "figure");
            Objects.requireNonNull(vehicleModel, "vehicleModel");
            vehicleModel.addAttributesChangeListener((AttributesChangeListener)this);
            this.setBackground(Color.WHITE);
            Rectangle r = figure.getBounds().getBounds();
            r.grow(10, 10);
            this.setPreferredSize(new Dimension(r.width, r.height));
            this.addMouseListener(new VehicleMouseAdapter(vehicleModel));
        }

        public void propertiesChanged(AttributesChangeEvent e) {
            this.figure.propertiesChanged(e);
            SwingUtilities.invokeLater(() -> this.repaint());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawVehicle((Graphics2D)g);
        }

        private void drawVehicle(Graphics2D g2d) {
            this.figure.setIgnorePrecisePosition(true);
            Point2D.Double posDialog = new Point2D.Double(SingleVehicleView.this.fVehicleView.getWidth() / 2, SingleVehicleView.this.fVehicleView.getHeight() / 2);
            this.figure.setBounds(posDialog, null);
            this.figure.setAngle(0.0);
            this.figure.forcedDraw(g2d);
        }
    }

    private class VehicleMouseAdapter
    extends MouseAdapter {
        private final VehicleModel vehicleModel;

        VehicleMouseAdapter(VehicleModel vehicleModel) {
            this.vehicleModel = Objects.requireNonNull(vehicleModel, "vehicleModel");
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() == 1) {
                SingleVehicleView.this.treeViewManager.selectItem((ModelComponent)this.vehicleModel);
                SingleVehicleView.this.propertiesComponent.setModel((ModelComponent)this.vehicleModel);
            }
            if (evt.getClickCount() == 2) {
                Figure vehicleFigure = SingleVehicleView.this.modelManager.getModel().getFigure((ModelComponent)this.vehicleModel);
                SingleVehicleView.this.drawingEditor.getActiveView().scrollTo(vehicleFigure);
            }
            if (evt.getButton() == 3) {
                SingleVehicleView.this.showPopup(evt.getX(), evt.getY());
            }
        }
    }
}

