/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.dialogs;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.dialogs.ModifiedFlowLayout;
import org.opentcs.guing.common.event.OperationModeChangeEvent;
import org.opentcs.guing.common.event.SystemModelTransitionEvent;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.components.dialogs.SingleVehicleView;
import org.opentcs.operationsdesk.components.dialogs.SingleVehicleViewFactory;
import org.opentcs.util.event.EventHandler;

public class VehiclesPanel
extends JPanel
implements EventHandler {
    private final ModelManager modelManager;
    private final SingleVehicleViewFactory vehicleViewFactory;
    private final SortedSet<SingleVehicleView> vehicleViews = new TreeSet<SingleVehicleView>();
    private JPanel panelVehicles;
    private JScrollPane scrollPaneVehicles;

    @Inject
    VehiclesPanel(ModelManager modelManager, SingleVehicleViewFactory vehicleViewFactory) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.vehicleViewFactory = Objects.requireNonNull(vehicleViewFactory, "vehicleViewFactory");
        this.initComponents();
        this.setPreferredSize(new Dimension(0, 97));
        this.setMinimumSize(new Dimension(140, 120));
        this.panelVehicles.setLayout((LayoutManager)new ModifiedFlowLayout(0, 10, 10));
    }

    public void onEvent(Object event) {
        if (event instanceof OperationModeChangeEvent) {
            this.handleModeChange((OperationModeChangeEvent)event);
        }
        if (event instanceof SystemModelTransitionEvent) {
            this.handleSystemModelTransition((SystemModelTransitionEvent)event);
        }
    }

    private void handleModeChange(OperationModeChangeEvent evt) {
        switch (evt.getNewMode()) {
            case OPERATING: {
                this.setVehicleModels(this.modelManager.getModel().getVehicleModels());
                break;
            }
            default: {
                this.clearVehicles();
            }
        }
    }

    public void setVehicleModels(Collection<VehicleModel> vehicleModels) {
        for (SingleVehicleView vehicleView : this.vehicleViews) {
            this.panelVehicles.remove(vehicleView);
        }
        this.vehicleViews.clear();
        for (VehicleModel vehicle : vehicleModels) {
            this.vehicleViews.add(this.vehicleViewFactory.createSingleVehicleView(vehicle));
        }
        for (SingleVehicleView vehicleView : this.vehicleViews) {
            this.panelVehicles.add(vehicleView);
        }
        this.panelVehicles.revalidate();
    }

    public void clearVehicles() {
        for (SingleVehicleView vehicleView : this.vehicleViews) {
            this.panelVehicles.remove(vehicleView);
        }
        this.vehicleViews.clear();
        this.repaint();
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.vehicleViews != null) {
            for (SingleVehicleView view : this.vehicleViews) {
                view.repaint();
            }
        }
    }

    private void handleSystemModelTransition(SystemModelTransitionEvent evt) {
        switch (evt.getStage()) {
            case UNLOADING: {
                this.clearVehicles();
                break;
            }
            case LOADED: {
                this.setVehicleModels(this.modelManager.getModel().getVehicleModels());
                break;
            }
        }
    }

    private void initComponents() {
        this.scrollPaneVehicles = new JScrollPane();
        this.panelVehicles = new JPanel();
        this.setName("VehiclesPanel");
        this.setLayout(new GridLayout(1, 0));
        this.scrollPaneVehicles.setViewportView(this.panelVehicles);
        this.add(this.scrollPaneVehicles);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/panels/vehicleView");
        this.getAccessibleContext().setAccessibleName(bundle.getString("vehiclesPanel.title"));
        this.getAccessibleContext().setAccessibleDescription("");
    }
}

