/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.drawing;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.base.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.components.properties.event.NullAttributesChangeListener;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.common.event.SystemModelTransitionEvent;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.CourseObjectFactory;
import org.opentcs.operationsdesk.components.drawing.figures.NamedVehicleFigure;
import org.opentcs.operationsdesk.util.VehicleCourseObjectFactory;

public class OpenTCSDrawingEditorOperating
extends OpenTCSDrawingEditor {
    private final ModelManager modelManager;
    private final VehicleCourseObjectFactory courseObjectFactory;

    @Inject
    public OpenTCSDrawingEditorOperating(VehicleCourseObjectFactory courseObjectFactory, ModelManager modelManager) {
        super((CourseObjectFactory)courseObjectFactory);
        this.courseObjectFactory = Objects.requireNonNull(courseObjectFactory, "courseObjectFactory");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            this.handleSystemModelTransition((SystemModelTransitionEvent)event);
        }
    }

    private void handleSystemModelTransition(SystemModelTransitionEvent evt) {
        switch (evt.getStage()) {
            case UNLOADING: {
                break;
            }
            case LOADED: {
                this.setVehicles(this.modelManager.getModel().getVehicleModels());
                break;
            }
        }
    }

    public void setVehicles(List<VehicleModel> vehicleModels) {
        for (VehicleModel vehicleComp : vehicleModels) {
            this.addVehicle(vehicleComp);
        }
    }

    public void addVehicle(VehicleModel vehicleModel) {
        NamedVehicleFigure vehicleFigure = this.courseObjectFactory.createNamedVehicleFigure(vehicleModel);
        SwingUtilities.invokeLater(() -> this.getDrawing().add((Figure)vehicleFigure));
        vehicleModel.addAttributesChangeListener((AttributesChangeListener)vehicleFigure);
        this.modelManager.getModel().registerFigure((ModelComponent)vehicleModel, (Figure)vehicleFigure);
        vehicleModel.setDisplayDriveOrders(true);
        for (OpenTCSDrawingView view : this.getAllViews()) {
            view.displayDriveOrders(vehicleModel, true);
        }
        vehicleFigure.propertiesChanged(new AttributesChangeEvent((AttributesChangeListener)new NullAttributesChangeListener(), (ModelComponent)vehicleModel));
    }
}

