/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.drawing.figures;

import com.google.inject.assistedinject.Assisted;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.Figure;
import org.opentcs.components.plantoverview.VehicleTheme;
import org.opentcs.data.model.Triple;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.application.ApplicationState;
import org.opentcs.guing.common.components.drawing.figures.ToolTipTextGenerator;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.application.menus.MenuFactory;
import org.opentcs.operationsdesk.components.drawing.figures.VehicleFigure;
import org.opentcs.operationsdesk.util.PlantOverviewOperatingApplicationConfiguration;

public class NamedVehicleFigure
extends VehicleFigure {
    @Inject
    public NamedVehicleFigure(VehicleTheme vehicleTheme, MenuFactory menuFactory, PlantOverviewOperatingApplicationConfiguration appConfig, @Assisted VehicleModel model, ToolTipTextGenerator textGenerator, ModelManager modelManager, ApplicationState applicationState) {
        super(vehicleTheme, menuFactory, appConfig, model, textGenerator, modelManager, applicationState);
    }

    @Override
    protected void drawFill(Graphics2D g2d) {
        super.drawFill(g2d);
        g2d.setFont(this.getVehicleTheme().labelFont());
        g2d.setPaint(this.getVehicleTheme().labelColor());
        g2d.drawString(this.getVehicleTheme().label(this.getModel().getVehicle()), (int)this.displayBox().getCenterX() + this.getVehicleTheme().labelOffsetX(), (int)this.displayBox().getCenterY() + this.getVehicleTheme().labelOffsetY());
    }

    @Override
    protected void updateFigureDetails(VehicleModel model) {
        super.updateFigureDetails(model);
        PointModel point = model.getPoint();
        Triple precisePosition = model.getPrecisePosition();
        if (point == null && precisePosition == null) {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        } else if (precisePosition != null && !this.isIgnorePrecisePosition()) {
            SwingUtilities.invokeLater(() -> {
                this.setVisible(true);
                this.setBounds(new Point2D.Double(), null);
            });
            this.setFigureDetailsChanged(true);
        } else if (point != null) {
            SwingUtilities.invokeLater(() -> {
                this.setVisible(true);
                Figure pointFigure = this.getModelManager().getModel().getFigure((ModelComponent)point);
                Rectangle2D.Double r = pointFigure.getBounds();
                Point2D.Double pCenter = new Point2D.Double(r.getCenterX(), r.getCenterY());
                this.setBounds(pCenter, null);
            });
            this.setFigureDetailsChanged(true);
        } else {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        }
    }

    public boolean isVisible() {
        if (this.getModel().getPoint() == null) {
            return super.isVisible();
        }
        return super.isVisible() && this.getModelManager().getModel().getFigure((ModelComponent)this.getModel().getPoint()).isVisible();
    }

    public int getLayer() {
        return 1000000;
    }
}

