/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.drawing.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jhotdraw.draw.event.FigureEvent;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.common.components.drawing.figures.TCSFigure;
import org.opentcs.guing.common.components.drawing.figures.TCSLabelFigure;

public class VehicleLabelFigure
extends TCSLabelFigure {
    private static final Color COLOR_BACKGROUND = new Color(0xFFFFF0);
    private static final int MARGIN = 4;

    public VehicleLabelFigure(String vehicleName) {
        super(vehicleName);
    }

    protected void drawFill(Graphics2D g) {
        if (this.getText() != null) {
            TextLayout layout = this.getTextLayout();
            Rectangle2D bounds = layout.getBounds();
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(bounds.getX() + this.origin.x - 4.0, bounds.getY() + this.origin.y + (double)layout.getAscent() - 4.0, bounds.getWidth() + 8.0, bounds.getHeight() + 2.0 + 4.0, 4.0, 4.0);
            g.setPaint(COLOR_BACKGROUND);
            g.fill(rr);
        }
    }

    protected void drawStroke(Graphics2D g) {
    }

    protected void drawText(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout layout = this.getTextLayout();
            g.setPaint(Color.BLUE.darker());
            layout.draw(g, (float)this.origin.x, (float)(this.origin.y + (double)layout.getAscent()));
        }
    }

    public void figureChanged(FigureEvent event) {
        if (event.getFigure() instanceof LabeledFigure) {
            LabeledFigure lf = (LabeledFigure)event.getFigure();
            TCSFigure figure = lf.getPresentationFigure();
            VehicleModel model = (VehicleModel)figure.getModel();
            Object name = model.getName();
            if (model.getPoint() != null) {
                name = (String)name + "@" + model.getPoint().getName();
            }
            this.setText((String)name);
            this.invalidate();
            this.validate();
        }
    }
}

