/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.components.layer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.opentcs.guing.common.components.layer.DisabledCheckBoxCellRenderer;
import org.opentcs.guing.common.components.layer.LayerChangeListener;
import org.opentcs.guing.common.components.layer.LayerEditor;
import org.opentcs.guing.common.components.layer.LayerGroupCellRenderer;
import org.opentcs.guing.common.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.common.components.layer.LayerGroupManager;
import org.opentcs.guing.common.components.layer.LayerManager;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.components.layer.LayersTableModel;

public class LayersPanel
extends JPanel {
    private final ModelManager modelManager;
    private final LayerManager layerManager;
    private final LayerGroupManager layerGroupManager;
    private final LayerEditor layerEditor;
    private JTable table;
    private LayersTableModel tableModel;

    @Inject
    public LayersPanel(ModelManager modelManager, LayerManager layerManager, LayerGroupManager layerGroupManager, LayerEditor layerEditor) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.layerManager = Objects.requireNonNull(layerManager, "layerManager");
        this.layerGroupManager = Objects.requireNonNull(layerGroupManager, "layerGroupManager");
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new LayersTableModel(this.modelManager, this.layerEditor);
        this.layerManager.setLayerChangeListener((LayerChangeListener)this.tableModel);
        this.layerGroupManager.addLayerGroupChangeListener((LayerGroupChangeListener)this.tableModel);
        this.table = new JTable(this.tableModel);
        this.initTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
    }

    private void initTable() {
        this.table.setSelectionMode(0);
        TableRowSorter<LayersTableModel> sorter = new TableRowSorter<LayersTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(0)));
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(3)).setCellRenderer((TableCellRenderer)new LayerGroupCellRenderer());
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(4)).setCellRenderer((TableCellRenderer)new DisabledCheckBoxCellRenderer());
    }
}

