/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.exchange;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.event.SystemModelTransitionEvent;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.exchange.adapter.LocationLockAdapter;
import org.opentcs.operationsdesk.exchange.adapter.PathLockAdapter;
import org.opentcs.operationsdesk.exchange.adapter.VehicleAllowedOrderTypesAdapter;
import org.opentcs.operationsdesk.exchange.adapter.VehiclePausedAdapter;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;

public class AttributeAdapterRegistry
implements EventHandler,
Lifecycle {
    private final SharedKernelServicePortalProvider portalProvider;
    private final ModelManager modelManager;
    private final EventSource eventSource;
    private boolean initialized;

    @Inject
    public AttributeAdapterRegistry(SharedKernelServicePortalProvider portalProvider, ModelManager modelManager, @ApplicationEventBus EventSource eventSource) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventSource.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventSource.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            SystemModelTransitionEvent evt = (SystemModelTransitionEvent)event;
            switch (evt.getStage()) {
                case LOADED: {
                    this.registerAdapters();
                    break;
                }
            }
        }
    }

    private void registerAdapters() {
        for (VehicleModel model : this.modelManager.getModel().getVehicleModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new VehicleAllowedOrderTypesAdapter(this.portalProvider, model));
            model.addAttributesChangeListener((AttributesChangeListener)new VehiclePausedAdapter(this.portalProvider, model));
        }
        for (VehicleModel model : this.modelManager.getModel().getPathModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new PathLockAdapter(this.portalProvider, (PathModel)model));
        }
        for (VehicleModel model : this.modelManager.getModel().getLocationModels()) {
            model.addAttributesChangeListener((AttributesChangeListener)new LocationLockAdapter(this.portalProvider, (LocationModel)model));
        }
    }
}

