/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.exchange;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.KernelStateTransitionEvent;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.common.application.OperationMode;
import org.opentcs.guing.common.event.OperationModeChangeEvent;
import org.opentcs.util.Assertions;
import org.opentcs.util.CyclicTask;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelEventFetcher
implements Lifecycle,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KernelEventFetcher.class);
    private final long eventFetchInterval = 1L;
    private final long eventFetchTimeout = 1000L;
    private final EventBus eventBus;
    private final SharedKernelServicePortalProvider servicePortalProvider;
    private SharedKernelServicePortal sharedServicePortal;
    private KernelServicePortal servicePortal;
    private EventFetcherTask eventFetcherTask;
    private boolean initialized;

    @Inject
    public KernelEventFetcher(@ApplicationEventBus EventBus eventBus, SharedKernelServicePortalProvider servicePortalProvider) {
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.servicePortalProvider = Objects.requireNonNull(servicePortalProvider, "servicePortalProvider");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        LOG.info("Initializing...");
        this.eventBus.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        LOG.info("Terminating...");
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof OperationModeChangeEvent) {
            this.handleOperationModeChange((OperationModeChangeEvent)event);
        }
    }

    private void handleOperationModeChange(OperationModeChangeEvent event) {
        if (event.getNewMode() == OperationMode.OPERATING) {
            this.handleKernelConnect();
        } else {
            this.handleKernelDisconnect();
        }
    }

    private void handleKernelConnect() {
        if (this.eventFetcherTask != null) {
            return;
        }
        this.sharedServicePortal = this.servicePortalProvider.register();
        this.servicePortal = this.sharedServicePortal.getPortal();
        this.eventFetcherTask = new EventFetcherTask(1L, 1000L);
        Thread eventFetcherThread = new Thread((Runnable)((Object)this.eventFetcherTask), "KernelEventFetcher");
        eventFetcherThread.start();
    }

    private void handleKernelDisconnect() {
        if (this.eventFetcherTask == null) {
            return;
        }
        this.eventFetcherTask.terminate();
        this.eventFetcherTask = null;
        this.sharedServicePortal.close();
        this.servicePortal = null;
    }

    private class EventFetcherTask
    extends CyclicTask {
        private final long timeout;

        private EventFetcherTask(long interval, long timeout) {
            super(interval);
            this.timeout = Assertions.checkInRange((long)timeout, (long)1L, (long)Long.MAX_VALUE, (String)"timeout");
        }

        protected void runActualTask() {
            boolean shutDown = false;
            try {
                LOG.debug("Fetching remote kernel for events");
                List events = KernelEventFetcher.this.servicePortal.fetchEvents(this.timeout);
                for (Object event : events) {
                    LOG.debug("Processing fetched event: {}", event);
                    KernelEventFetcher.this.eventBus.onEvent(event);
                    if (!(event instanceof KernelStateTransitionEvent)) continue;
                    KernelStateTransitionEvent stateEvent = (KernelStateTransitionEvent)event;
                    shutDown = stateEvent.getEnteredState() == Kernel.State.SHUTDOWN;
                }
            }
            catch (KernelRuntimeException exc) {
                LOG.error("Exception fetching events, logging out", (Throwable)exc);
                shutDown = true;
            }
            if (shutDown) {
                KernelEventFetcher.this.eventBus.onEvent((Object)ClientConnectionMode.OFFLINE);
            }
        }
    }
}

