/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.exchange.adapter;

import java.util.Objects;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.data.model.Vehicle;
import org.opentcs.guing.base.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehiclePausedAdapter
implements AttributesChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(VehiclePausedAdapter.class);
    private final VehicleModel model;
    private final SharedKernelServicePortalProvider portalProvider;
    private boolean pausedPreviously;

    public VehiclePausedAdapter(SharedKernelServicePortalProvider portalProvider, VehicleModel model) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.model = Objects.requireNonNull(model, "model");
        this.pausedPreviously = this.isVehiclePaused();
    }

    public void propertiesChanged(AttributesChangeEvent e) {
        if (e.getModel() != this.model) {
            return;
        }
        boolean paused = this.isVehiclePaused();
        if (paused == this.pausedPreviously) {
            return;
        }
        this.pausedPreviously = paused;
        new Thread(() -> this.updatePausedInKernel(paused)).start();
    }

    private boolean isVehiclePaused() {
        return Boolean.TRUE.equals(this.model.getPropertyPaused().getValue());
    }

    private void updatePausedInKernel(boolean paused) {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            Vehicle vehicle;
            KernelServicePortal portal = sharedPortal.getPortal();
            if (portal.getState() == Kernel.State.OPERATING && (vehicle = (Vehicle)portal.getVehicleService().fetchObject(Vehicle.class, this.model.getName())) != null && vehicle.isPaused() != paused) {
                portal.getVehicleService().updateVehiclePaused(vehicle.getReference(), paused);
            }
        }
        catch (ServiceUnavailableException exc) {
            LOG.warn("Could not connect to kernel", (Throwable)exc);
        }
    }
}

