/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.model;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.LocationTypeModel;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.model.StandardSystemModel;
import org.opentcs.guing.common.util.ModelComponentFactory;

public class CachedSystemModel
extends StandardSystemModel {
    private final Map<String, ModelComponent> components = new HashMap<String, ModelComponent>();

    @Inject
    public CachedSystemModel(ModelComponentFactory modelComponentFactory) {
        super(modelComponentFactory);
    }

    public void onRestorationComplete() {
        this.components.clear();
        for (ModelComponent component : this.getAll()) {
            this.components.put(component.getName(), component);
        }
    }

    public BlockModel getBlockModel(String name) {
        if (this.components.isEmpty()) {
            return super.getBlockModel(name);
        }
        ModelComponent block = this.components.get(name);
        if (block instanceof BlockModel) {
            return (BlockModel)block;
        }
        return null;
    }

    public LocationModel getLocationModel(String name) {
        if (this.components.isEmpty()) {
            return super.getLocationModel(name);
        }
        ModelComponent location = this.components.get(name);
        if (location instanceof LocationModel) {
            return (LocationModel)location;
        }
        return null;
    }

    public LocationTypeModel getLocationTypeModel(String name) {
        if (this.components.isEmpty()) {
            return super.getLocationTypeModel(name);
        }
        ModelComponent locationType = this.components.get(name);
        if (locationType instanceof LocationTypeModel) {
            return (LocationTypeModel)locationType;
        }
        return null;
    }

    public ModelComponent getModelComponent(String name) {
        if (this.components.isEmpty()) {
            return super.getModelComponent(name);
        }
        return this.components.get(name);
    }

    public PathModel getPathModel(String name) {
        if (this.components.isEmpty()) {
            return super.getPathModel(name);
        }
        ModelComponent path = this.components.get(name);
        if (path instanceof PathModel) {
            return (PathModel)path;
        }
        return null;
    }

    public PointModel getPointModel(String name) {
        if (this.components.isEmpty()) {
            return super.getPointModel(name);
        }
        ModelComponent point = this.components.get(name);
        if (point instanceof PointModel) {
            return (PointModel)point;
        }
        return null;
    }

    public VehicleModel getVehicleModel(String name) {
        if (this.components.isEmpty()) {
            return super.getVehicleModel(name);
        }
        ModelComponent vehicle = this.components.get(name);
        if (vehicle instanceof VehicleModel) {
            return (VehicleModel)vehicle;
        }
        return null;
    }
}

